package org.graylog.events.processor.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationSeriesValue extends AggregationSeriesValue {

  private final AggregationSeries series;

  private final ImmutableList<String> key;

  private final double value;

  private AutoValue_AggregationSeriesValue(
      AggregationSeries series,
      ImmutableList<String> key,
      double value) {
    this.series = series;
    this.key = key;
    this.value = value;
  }

  @Override
  public AggregationSeries series() {
    return series;
  }

  @Override
  public ImmutableList<String> key() {
    return key;
  }

  @Override
  public double value() {
    return value;
  }

  @Override
  public String toString() {
    return "AggregationSeriesValue{"
        + "series=" + series + ", "
        + "key=" + key + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationSeriesValue) {
      AggregationSeriesValue that = (AggregationSeriesValue) o;
      return this.series.equals(that.series())
          && this.key.equals(that.key())
          && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= series.hashCode();
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(value) >>> 32) ^ Double.doubleToLongBits(value));
    return h$;
  }

  @Override
  public AggregationSeriesValue.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationSeriesValue.Builder {
    private AggregationSeries series;
    private ImmutableList<String> key;
    private Double value;
    Builder() {
    }
    private Builder(AggregationSeriesValue source) {
      this.series = source.series();
      this.key = source.key();
      this.value = source.value();
    }
    @Override
    public AggregationSeriesValue.Builder series(AggregationSeries series) {
      if (series == null) {
        throw new NullPointerException("Null series");
      }
      this.series = series;
      return this;
    }
    @Override
    public AggregationSeriesValue.Builder key(List<String> key) {
      this.key = ImmutableList.copyOf(key);
      return this;
    }
    @Override
    public AggregationSeriesValue.Builder value(double value) {
      this.value = value;
      return this;
    }
    @Override
    public AggregationSeriesValue build() {
      String missing = "";
      if (this.series == null) {
        missing += " series";
      }
      if (this.key == null) {
        missing += " key";
      }
      if (this.value == null) {
        missing += " value";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationSeriesValue(
          this.series,
          this.key,
          this.value);
    }
  }

}
