package org.graylog.events.processor.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PersistToStreamsStorageHandler_Config extends PersistToStreamsStorageHandler.Config {

  private final String type;

  private final ImmutableList<String> streams;

  private AutoValue_PersistToStreamsStorageHandler_Config(
      String type,
      ImmutableList<String> streams) {
    this.type = type;
    this.streams = streams;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("streams")
  @Override
  public ImmutableList<String> streams() {
    return streams;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "streams=" + streams
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PersistToStreamsStorageHandler.Config) {
      PersistToStreamsStorageHandler.Config that = (PersistToStreamsStorageHandler.Config) o;
      return this.type.equals(that.type())
          && this.streams.equals(that.streams());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    return h$;
  }

  @Override
  public PersistToStreamsStorageHandler.Config.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PersistToStreamsStorageHandler.Config.Builder {
    private String type;
    private ImmutableList<String> streams;
    Builder() {
    }
    private Builder(PersistToStreamsStorageHandler.Config source) {
      this.type = source.type();
      this.streams = source.streams();
    }
    @Override
    public PersistToStreamsStorageHandler.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public PersistToStreamsStorageHandler.Config.Builder streams(List<String> streams) {
      this.streams = ImmutableList.copyOf(streams);
      return this;
    }
    @Override
    public PersistToStreamsStorageHandler.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PersistToStreamsStorageHandler_Config(
          this.type,
          this.streams);
    }
  }

}
