package org.graylog.events.search;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog2.indexer.results.ResultMessage;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MoreSearch_Result extends MoreSearch.Result {

  private final List<ResultMessage> results;

  private final long resultsCount;

  private final long duration;

  private final Set<String> usedIndexNames;

  private final String executedQuery;

  private AutoValue_MoreSearch_Result(
      List<ResultMessage> results,
      long resultsCount,
      long duration,
      Set<String> usedIndexNames,
      String executedQuery) {
    this.results = results;
    this.resultsCount = resultsCount;
    this.duration = duration;
    this.usedIndexNames = usedIndexNames;
    this.executedQuery = executedQuery;
  }

  @Override
  public List<ResultMessage> results() {
    return results;
  }

  @Override
  public long resultsCount() {
    return resultsCount;
  }

  @Override
  public long duration() {
    return duration;
  }

  @Override
  public Set<String> usedIndexNames() {
    return usedIndexNames;
  }

  @Override
  public String executedQuery() {
    return executedQuery;
  }

  @Override
  public String toString() {
    return "Result{"
        + "results=" + results + ", "
        + "resultsCount=" + resultsCount + ", "
        + "duration=" + duration + ", "
        + "usedIndexNames=" + usedIndexNames + ", "
        + "executedQuery=" + executedQuery
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MoreSearch.Result) {
      MoreSearch.Result that = (MoreSearch.Result) o;
      return this.results.equals(that.results())
          && this.resultsCount == that.resultsCount()
          && this.duration == that.duration()
          && this.usedIndexNames.equals(that.usedIndexNames())
          && this.executedQuery.equals(that.executedQuery());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= results.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((resultsCount >>> 32) ^ resultsCount);
    h$ *= 1000003;
    h$ ^= (int) ((duration >>> 32) ^ duration);
    h$ *= 1000003;
    h$ ^= usedIndexNames.hashCode();
    h$ *= 1000003;
    h$ ^= executedQuery.hashCode();
    return h$;
  }

  static final class Builder extends MoreSearch.Result.Builder {
    private List<ResultMessage> results;
    private Long resultsCount;
    private Long duration;
    private Set<String> usedIndexNames;
    private String executedQuery;
    Builder() {
    }
    @Override
    public MoreSearch.Result.Builder results(List<ResultMessage> results) {
      if (results == null) {
        throw new NullPointerException("Null results");
      }
      this.results = results;
      return this;
    }
    @Override
    public MoreSearch.Result.Builder resultsCount(long resultsCount) {
      this.resultsCount = resultsCount;
      return this;
    }
    @Override
    public MoreSearch.Result.Builder duration(long duration) {
      this.duration = duration;
      return this;
    }
    @Override
    public MoreSearch.Result.Builder usedIndexNames(Set<String> usedIndexNames) {
      if (usedIndexNames == null) {
        throw new NullPointerException("Null usedIndexNames");
      }
      this.usedIndexNames = usedIndexNames;
      return this;
    }
    @Override
    public MoreSearch.Result.Builder executedQuery(String executedQuery) {
      if (executedQuery == null) {
        throw new NullPointerException("Null executedQuery");
      }
      this.executedQuery = executedQuery;
      return this;
    }
    @Override
    public MoreSearch.Result build() {
      String missing = "";
      if (this.results == null) {
        missing += " results";
      }
      if (this.resultsCount == null) {
        missing += " resultsCount";
      }
      if (this.duration == null) {
        missing += " duration";
      }
      if (this.usedIndexNames == null) {
        missing += " usedIndexNames";
      }
      if (this.executedQuery == null) {
        missing += " executedQuery";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MoreSearch_Result(
          this.results,
          this.resultsCount,
          this.duration,
          this.usedIndexNames,
          this.executedQuery);
    }
  }

}
