package org.graylog.plugins.map.geoip;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GeoLocationInformation extends GeoLocationInformation {

  private final double latitude;

  private final double longitude;

  private final String countryIsoCode;

  private final String countryName;

  private final String cityName;

  private final String region;

  private final String timeZone;

  AutoValue_GeoLocationInformation(
      double latitude,
      double longitude,
      String countryIsoCode,
      String countryName,
      String cityName,
      String region,
      String timeZone) {
    this.latitude = latitude;
    this.longitude = longitude;
    if (countryIsoCode == null) {
      throw new NullPointerException("Null countryIsoCode");
    }
    this.countryIsoCode = countryIsoCode;
    if (countryName == null) {
      throw new NullPointerException("Null countryName");
    }
    this.countryName = countryName;
    if (cityName == null) {
      throw new NullPointerException("Null cityName");
    }
    this.cityName = cityName;
    if (region == null) {
      throw new NullPointerException("Null region");
    }
    this.region = region;
    if (timeZone == null) {
      throw new NullPointerException("Null timeZone");
    }
    this.timeZone = timeZone;
  }

  @Override
  public double latitude() {
    return latitude;
  }

  @Override
  public double longitude() {
    return longitude;
  }

  @Override
  public String countryIsoCode() {
    return countryIsoCode;
  }

  @Override
  public String countryName() {
    return countryName;
  }

  @Override
  public String cityName() {
    return cityName;
  }

  @Override
  public String region() {
    return region;
  }

  @Override
  public String timeZone() {
    return timeZone;
  }

  @Override
  public String toString() {
    return "GeoLocationInformation{"
        + "latitude=" + latitude + ", "
        + "longitude=" + longitude + ", "
        + "countryIsoCode=" + countryIsoCode + ", "
        + "countryName=" + countryName + ", "
        + "cityName=" + cityName + ", "
        + "region=" + region + ", "
        + "timeZone=" + timeZone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GeoLocationInformation) {
      GeoLocationInformation that = (GeoLocationInformation) o;
      return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(that.latitude())
          && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(that.longitude())
          && this.countryIsoCode.equals(that.countryIsoCode())
          && this.countryName.equals(that.countryName())
          && this.cityName.equals(that.cityName())
          && this.region.equals(that.region())
          && this.timeZone.equals(that.timeZone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(latitude) >>> 32) ^ Double.doubleToLongBits(latitude));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(longitude) >>> 32) ^ Double.doubleToLongBits(longitude));
    h$ *= 1000003;
    h$ ^= countryIsoCode.hashCode();
    h$ *= 1000003;
    h$ ^= countryName.hashCode();
    h$ *= 1000003;
    h$ ^= cityName.hashCode();
    h$ *= 1000003;
    h$ ^= region.hashCode();
    h$ *= 1000003;
    h$ ^= timeZone.hashCode();
    return h$;
  }

}
