package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RuleSource extends RuleSource {

  private final String id;

  private final String title;

  private final String description;

  private final String source;

  private final DateTime createdAt;

  private final DateTime modifiedAt;

  private final Set<ParseError> errors;

  private AutoValue_RuleSource(
      @Nullable String id,
      @Nullable String title,
      @Nullable String description,
      String source,
      @Nullable DateTime createdAt,
      @Nullable DateTime modifiedAt,
      @Nullable Set<ParseError> errors) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.source = source;
    this.createdAt = createdAt;
    this.modifiedAt = modifiedAt;
    this.errors = errors;
  }

  @JsonProperty("id")
  @Nullable
  @Id
  @ObjectId
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Nullable
  @Override
  public String title() {
    return title;
  }

  @JsonProperty
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty
  @Override
  public String source() {
    return source;
  }

  @JsonProperty
  @Nullable
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @JsonProperty
  @Nullable
  @Override
  public DateTime modifiedAt() {
    return modifiedAt;
  }

  @JsonProperty
  @Nullable
  @Override
  public Set<ParseError> errors() {
    return errors;
  }

  @Override
  public String toString() {
    return "RuleSource{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "source=" + source + ", "
        + "createdAt=" + createdAt + ", "
        + "modifiedAt=" + modifiedAt + ", "
        + "errors=" + errors
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RuleSource) {
      RuleSource that = (RuleSource) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && (this.title == null ? that.title() == null : this.title.equals(that.title()))
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.source.equals(that.source())
          && (this.createdAt == null ? that.createdAt() == null : this.createdAt.equals(that.createdAt()))
          && (this.modifiedAt == null ? that.modifiedAt() == null : this.modifiedAt.equals(that.modifiedAt()))
          && (this.errors == null ? that.errors() == null : this.errors.equals(that.errors()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= (title == null) ? 0 : title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= (createdAt == null) ? 0 : createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= (modifiedAt == null) ? 0 : modifiedAt.hashCode();
    h$ *= 1000003;
    h$ ^= (errors == null) ? 0 : errors.hashCode();
    return h$;
  }

  @Override
  public RuleSource.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends RuleSource.Builder {
    private String id;
    private String title;
    private String description;
    private String source;
    private DateTime createdAt;
    private DateTime modifiedAt;
    private Set<ParseError> errors;
    Builder() {
    }
    private Builder(RuleSource source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.source = source.source();
      this.createdAt = source.createdAt();
      this.modifiedAt = source.modifiedAt();
      this.errors = source.errors();
    }
    @Override
    public RuleSource.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public RuleSource.Builder title(String title) {
      this.title = title;
      return this;
    }
    @Override
    public RuleSource.Builder description(String description) {
      this.description = description;
      return this;
    }
    @Override
    public RuleSource.Builder source(String source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public RuleSource.Builder createdAt(DateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public RuleSource.Builder modifiedAt(DateTime modifiedAt) {
      this.modifiedAt = modifiedAt;
      return this;
    }
    @Override
    public RuleSource.Builder errors(Set<ParseError> errors) {
      this.errors = errors;
      return this;
    }
    @Override
    public RuleSource build() {
      String missing = "";
      if (this.source == null) {
        missing += " source";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RuleSource(
          this.id,
          this.title,
          this.description,
          this.source,
          this.createdAt,
          this.modifiedAt,
          this.errors);
    }
  }

}
