package org.graylog.plugins.sidecar.system;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;
import org.joda.time.Period;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_SidecarConfiguration extends SidecarConfiguration {

  private final Period sidecarExpirationThreshold;

  private final Period sidecarInactiveThreshold;

  private final Period sidecarUpdateInterval;

  private final boolean sidecarSendStatus;

  private final boolean sidecarConfigurationOverride;

  $AutoValue_SidecarConfiguration(
      Period sidecarExpirationThreshold,
      Period sidecarInactiveThreshold,
      Period sidecarUpdateInterval,
      boolean sidecarSendStatus,
      boolean sidecarConfigurationOverride) {
    if (sidecarExpirationThreshold == null) {
      throw new NullPointerException("Null sidecarExpirationThreshold");
    }
    this.sidecarExpirationThreshold = sidecarExpirationThreshold;
    if (sidecarInactiveThreshold == null) {
      throw new NullPointerException("Null sidecarInactiveThreshold");
    }
    this.sidecarInactiveThreshold = sidecarInactiveThreshold;
    if (sidecarUpdateInterval == null) {
      throw new NullPointerException("Null sidecarUpdateInterval");
    }
    this.sidecarUpdateInterval = sidecarUpdateInterval;
    this.sidecarSendStatus = sidecarSendStatus;
    this.sidecarConfigurationOverride = sidecarConfigurationOverride;
  }

  @JsonProperty("sidecar_expiration_threshold")
  @Override
  public Period sidecarExpirationThreshold() {
    return sidecarExpirationThreshold;
  }

  @JsonProperty("sidecar_inactive_threshold")
  @Override
  public Period sidecarInactiveThreshold() {
    return sidecarInactiveThreshold;
  }

  @JsonProperty("sidecar_update_interval")
  @Override
  public Period sidecarUpdateInterval() {
    return sidecarUpdateInterval;
  }

  @JsonProperty("sidecar_send_status")
  @Override
  public boolean sidecarSendStatus() {
    return sidecarSendStatus;
  }

  @JsonProperty("sidecar_configuration_override")
  @Override
  public boolean sidecarConfigurationOverride() {
    return sidecarConfigurationOverride;
  }

  @Override
  public String toString() {
    return "SidecarConfiguration{"
        + "sidecarExpirationThreshold=" + sidecarExpirationThreshold + ", "
        + "sidecarInactiveThreshold=" + sidecarInactiveThreshold + ", "
        + "sidecarUpdateInterval=" + sidecarUpdateInterval + ", "
        + "sidecarSendStatus=" + sidecarSendStatus + ", "
        + "sidecarConfigurationOverride=" + sidecarConfigurationOverride
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SidecarConfiguration) {
      SidecarConfiguration that = (SidecarConfiguration) o;
      return this.sidecarExpirationThreshold.equals(that.sidecarExpirationThreshold())
          && this.sidecarInactiveThreshold.equals(that.sidecarInactiveThreshold())
          && this.sidecarUpdateInterval.equals(that.sidecarUpdateInterval())
          && this.sidecarSendStatus == that.sidecarSendStatus()
          && this.sidecarConfigurationOverride == that.sidecarConfigurationOverride();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= sidecarExpirationThreshold.hashCode();
    h$ *= 1000003;
    h$ ^= sidecarInactiveThreshold.hashCode();
    h$ *= 1000003;
    h$ ^= sidecarUpdateInterval.hashCode();
    h$ *= 1000003;
    h$ ^= sidecarSendStatus ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= sidecarConfigurationOverride ? 1231 : 1237;
    return h$;
  }

  @Override
  public SidecarConfiguration.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends SidecarConfiguration.Builder {
    private Period sidecarExpirationThreshold;
    private Period sidecarInactiveThreshold;
    private Period sidecarUpdateInterval;
    private Boolean sidecarSendStatus;
    private Boolean sidecarConfigurationOverride;
    Builder() {
    }
    private Builder(SidecarConfiguration source) {
      this.sidecarExpirationThreshold = source.sidecarExpirationThreshold();
      this.sidecarInactiveThreshold = source.sidecarInactiveThreshold();
      this.sidecarUpdateInterval = source.sidecarUpdateInterval();
      this.sidecarSendStatus = source.sidecarSendStatus();
      this.sidecarConfigurationOverride = source.sidecarConfigurationOverride();
    }
    @Override
    public SidecarConfiguration.Builder sidecarExpirationThreshold(Period sidecarExpirationThreshold) {
      if (sidecarExpirationThreshold == null) {
        throw new NullPointerException("Null sidecarExpirationThreshold");
      }
      this.sidecarExpirationThreshold = sidecarExpirationThreshold;
      return this;
    }
    @Override
    public SidecarConfiguration.Builder sidecarInactiveThreshold(Period sidecarInactiveThreshold) {
      if (sidecarInactiveThreshold == null) {
        throw new NullPointerException("Null sidecarInactiveThreshold");
      }
      this.sidecarInactiveThreshold = sidecarInactiveThreshold;
      return this;
    }
    @Override
    public SidecarConfiguration.Builder sidecarUpdateInterval(Period sidecarUpdateInterval) {
      if (sidecarUpdateInterval == null) {
        throw new NullPointerException("Null sidecarUpdateInterval");
      }
      this.sidecarUpdateInterval = sidecarUpdateInterval;
      return this;
    }
    @Override
    public SidecarConfiguration.Builder sidecarSendStatus(boolean sidecarSendStatus) {
      this.sidecarSendStatus = sidecarSendStatus;
      return this;
    }
    @Override
    public SidecarConfiguration.Builder sidecarConfigurationOverride(boolean sidecarConfigurationOverride) {
      this.sidecarConfigurationOverride = sidecarConfigurationOverride;
      return this;
    }
    @Override
    public SidecarConfiguration build() {
      String missing = "";
      if (this.sidecarExpirationThreshold == null) {
        missing += " sidecarExpirationThreshold";
      }
      if (this.sidecarInactiveThreshold == null) {
        missing += " sidecarInactiveThreshold";
      }
      if (this.sidecarUpdateInterval == null) {
        missing += " sidecarUpdateInterval";
      }
      if (this.sidecarSendStatus == null) {
        missing += " sidecarSendStatus";
      }
      if (this.sidecarConfigurationOverride == null) {
        missing += " sidecarConfigurationOverride";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SidecarConfiguration(
          this.sidecarExpirationThreshold,
          this.sidecarInactiveThreshold,
          this.sidecarUpdateInterval,
          this.sidecarSendStatus,
          this.sidecarConfigurationOverride);
    }
  }

}
