package org.graylog.plugins.sidecar.system;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.joda.time.Period;

final class AutoValue_SidecarConfiguration extends $AutoValue_SidecarConfiguration {
  AutoValue_SidecarConfiguration(Period sidecarExpirationThreshold, Period sidecarInactiveThreshold,
      Period sidecarUpdateInterval, boolean sidecarSendStatus,
      boolean sidecarConfigurationOverride) {
    super(sidecarExpirationThreshold, sidecarInactiveThreshold, sidecarUpdateInterval, sidecarSendStatus, sidecarConfigurationOverride);
  }

  @JsonIgnore
  public final Period getSidecarExpirationThreshold() {
    return sidecarExpirationThreshold();
  }

  @JsonIgnore
  public final Period getSidecarInactiveThreshold() {
    return sidecarInactiveThreshold();
  }

  @JsonIgnore
  public final Period getSidecarUpdateInterval() {
    return sidecarUpdateInterval();
  }

  @JsonIgnore
  public final boolean isSidecarSendStatus() {
    return sidecarSendStatus();
  }

  @JsonIgnore
  public final boolean isSidecarConfigurationOverride() {
    return sidecarConfigurationOverride();
  }
}
