package org.graylog.plugins.threatintel.adapters.otx;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;

final class AutoValue_OTXDataAdapter_Config extends $AutoValue_OTXDataAdapter_Config {
  AutoValue_OTXDataAdapter_Config(String type, String indicator, String apiKey, String apiUrl,
      String httpUserAgent, long httpConnectTimeout, long httpWriteTimeout, long httpReadTimeout) {
    super(type, indicator, apiKey, apiUrl, httpUserAgent, httpConnectTimeout, httpWriteTimeout, httpReadTimeout);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  @NotEmpty
  public final String getIndicator() {
    return indicator();
  }

  @JsonIgnore
  @Nullable
  public final String getApiKey() {
    return apiKey();
  }

  @JsonIgnore
  @NotEmpty
  public final String getApiUrl() {
    return apiUrl();
  }

  @JsonIgnore
  @NotEmpty
  public final String getHttpUserAgent() {
    return httpUserAgent();
  }

  @JsonIgnore
  @Min(1)
  public final long getHttpConnectTimeout() {
    return httpConnectTimeout();
  }

  @JsonIgnore
  @Min(1)
  public final long getHttpWriteTimeout() {
    return httpWriteTimeout();
  }

  @JsonIgnore
  @Min(1)
  public final long getHttpReadTimeout() {
    return httpReadTimeout();
  }
}
