package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_View extends $AutoValue_View {
  AutoValue_View(String id, View.Type type, String title, String summary, String description,
      String searchId, Map<String, ViewState> state, Optional<String> owner, DateTime createdAt) {
    super(id, type, title, summary, description, searchId, state, owner, createdAt);
  }

  @JsonIgnore
  @ObjectId
  @Id
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final View.Type getType() {
    return type();
  }

  @JsonIgnore
  @NotBlank
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getSummary() {
    return summary();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  public final String getSearchId() {
    return searchId();
  }

  @JsonIgnore
  public final Map<String, ViewState> getState() {
    return state();
  }

  @JsonIgnore
  public final Optional<String> getOwner() {
    return owner();
  }

  @JsonIgnore
  public final DateTime getCreatedAt() {
    return createdAt();
  }
}
