package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValueParameter extends ValueParameter {

  private final String type;

  private final String name;

  private final String title;

  private final String description;

  private final String dataType;

  private final Object defaultValue;

  private final boolean optional;

  private final Parameter.Binding binding;

  private AutoValue_ValueParameter(
      String type,
      String name,
      @Nullable String title,
      @Nullable String description,
      String dataType,
      @Nullable Object defaultValue,
      boolean optional,
      @Nullable Parameter.Binding binding) {
    this.type = type;
    this.name = name;
    this.title = title;
    this.description = description;
    this.dataType = dataType;
    this.defaultValue = defaultValue;
    this.optional = optional;
    this.binding = binding;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  @Nullable
  @JsonProperty
  @Override
  public String title() {
    return title;
  }

  @Nullable
  @JsonProperty
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("data_type")
  @Override
  public String dataType() {
    return dataType;
  }

  @Nullable
  @JsonProperty("default_value")
  @Override
  public Object defaultValue() {
    return defaultValue;
  }

  @JsonProperty
  @Override
  public boolean optional() {
    return optional;
  }

  @Nullable
  @JsonProperty
  @Override
  public Parameter.Binding binding() {
    return binding;
  }

  @Override
  public String toString() {
    return "ValueParameter{"
        + "type=" + type + ", "
        + "name=" + name + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "dataType=" + dataType + ", "
        + "defaultValue=" + defaultValue + ", "
        + "optional=" + optional + ", "
        + "binding=" + binding
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValueParameter) {
      ValueParameter that = (ValueParameter) o;
      return this.type.equals(that.type())
          && this.name.equals(that.name())
          && (this.title == null ? that.title() == null : this.title.equals(that.title()))
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.dataType.equals(that.dataType())
          && (this.defaultValue == null ? that.defaultValue() == null : this.defaultValue.equals(that.defaultValue()))
          && this.optional == that.optional()
          && (this.binding == null ? that.binding() == null : this.binding.equals(that.binding()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (title == null) ? 0 : title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= dataType.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
    h$ *= 1000003;
    h$ ^= optional ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (binding == null) ? 0 : binding.hashCode();
    return h$;
  }

  @Override
  public ValueParameter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ValueParameter.Builder {
    private String type;
    private String name;
    private String title;
    private String description;
    private String dataType;
    private Object defaultValue;
    private Boolean optional;
    private Parameter.Binding binding;
    Builder() {
    }
    private Builder(ValueParameter source) {
      this.type = source.type();
      this.name = source.name();
      this.title = source.title();
      this.description = source.description();
      this.dataType = source.dataType();
      this.defaultValue = source.defaultValue();
      this.optional = source.optional();
      this.binding = source.binding();
    }
    @Override
    public ValueParameter.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ValueParameter.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ValueParameter.Builder title(String title) {
      this.title = title;
      return this;
    }
    @Override
    public ValueParameter.Builder description(String description) {
      this.description = description;
      return this;
    }
    @Override
    public ValueParameter.Builder dataType(String dataType) {
      if (dataType == null) {
        throw new NullPointerException("Null dataType");
      }
      this.dataType = dataType;
      return this;
    }
    @Override
    public ValueParameter.Builder defaultValue(Object defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }
    @Override
    public ValueParameter.Builder optional(boolean optional) {
      this.optional = optional;
      return this;
    }
    @Override
    public ValueParameter.Builder binding(Parameter.Binding binding) {
      this.binding = binding;
      return this;
    }
    @Override
    public ValueParameter build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.dataType == null) {
        missing += " dataType";
      }
      if (this.optional == null) {
        missing += " optional";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValueParameter(
          this.type,
          this.name,
          this.title,
          this.description,
          this.dataType,
          this.defaultValue,
          this.optional,
          this.binding);
    }
  }

}
