package org.graylog.plugins.views.search.events;

import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog2.plugin.database.users.User;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SearchJobExecutionEvent extends SearchJobExecutionEvent {

  private final User user;

  private final SearchJob searchJob;

  private final DateTime executionStart;

  AutoValue_SearchJobExecutionEvent(
      User user,
      SearchJob searchJob,
      DateTime executionStart) {
    if (user == null) {
      throw new NullPointerException("Null user");
    }
    this.user = user;
    if (searchJob == null) {
      throw new NullPointerException("Null searchJob");
    }
    this.searchJob = searchJob;
    if (executionStart == null) {
      throw new NullPointerException("Null executionStart");
    }
    this.executionStart = executionStart;
  }

  @Override
  public User user() {
    return user;
  }

  @Override
  public SearchJob searchJob() {
    return searchJob;
  }

  @Override
  public DateTime executionStart() {
    return executionStart;
  }

  @Override
  public String toString() {
    return "SearchJobExecutionEvent{"
        + "user=" + user + ", "
        + "searchJob=" + searchJob + ", "
        + "executionStart=" + executionStart
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchJobExecutionEvent) {
      SearchJobExecutionEvent that = (SearchJobExecutionEvent) o;
      return this.user.equals(that.user())
          && this.searchJob.equals(that.searchJob())
          && this.executionStart.equals(that.executionStart());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= user.hashCode();
    h$ *= 1000003;
    h$ ^= searchJob.hashCode();
    h$ *= 1000003;
    h$ ^= executionStart.hashCode();
    return h$;
  }

}
