package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTimeZone;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ResultFormat extends ResultFormat {

  private final @NotEmpty LinkedHashSet<String> fieldsInOrder;

  private final Optional<AbsoluteRange> timerange;

  private final Optional<Integer> limit;

  private final ExecutionState executionState;

  private final Optional<String> filename;

  private final Optional<DateTimeZone> timeZone;

  private AutoValue_ResultFormat(
      @NotEmpty LinkedHashSet<String> fieldsInOrder,
      Optional<AbsoluteRange> timerange,
      Optional<Integer> limit,
      ExecutionState executionState,
      Optional<String> filename,
      Optional<DateTimeZone> timeZone) {
    this.fieldsInOrder = fieldsInOrder;
    this.timerange = timerange;
    this.limit = limit;
    this.executionState = executionState;
    this.filename = filename;
    this.timeZone = timeZone;
  }

  @JsonProperty("fields_in_order")
  @Override
  public @NotEmpty LinkedHashSet<String> fieldsInOrder() {
    return fieldsInOrder;
  }

  @JsonProperty
  @Override
  public Optional<AbsoluteRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<Integer> limit() {
    return limit;
  }

  @JsonProperty
  @Override
  public ExecutionState executionState() {
    return executionState;
  }

  @JsonProperty
  @Override
  public Optional<String> filename() {
    return filename;
  }

  @JsonProperty
  @Override
  public Optional<DateTimeZone> timeZone() {
    return timeZone;
  }

  @Override
  public String toString() {
    return "ResultFormat{"
        + "fieldsInOrder=" + fieldsInOrder + ", "
        + "timerange=" + timerange + ", "
        + "limit=" + limit + ", "
        + "executionState=" + executionState + ", "
        + "filename=" + filename + ", "
        + "timeZone=" + timeZone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ResultFormat) {
      ResultFormat that = (ResultFormat) o;
      return this.fieldsInOrder.equals(that.fieldsInOrder())
          && this.timerange.equals(that.timerange())
          && this.limit.equals(that.limit())
          && this.executionState.equals(that.executionState())
          && this.filename.equals(that.filename())
          && this.timeZone.equals(that.timeZone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fieldsInOrder.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= executionState.hashCode();
    h$ *= 1000003;
    h$ ^= filename.hashCode();
    h$ *= 1000003;
    h$ ^= timeZone.hashCode();
    return h$;
  }

  @Override
  ResultFormat.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ResultFormat.Builder {
    private @NotEmpty LinkedHashSet<String> fieldsInOrder;
    private Optional<AbsoluteRange> timerange = Optional.empty();
    private Optional<Integer> limit = Optional.empty();
    private ExecutionState executionState;
    private Optional<String> filename = Optional.empty();
    private Optional<DateTimeZone> timeZone = Optional.empty();
    Builder() {
    }
    private Builder(ResultFormat source) {
      this.fieldsInOrder = source.fieldsInOrder();
      this.timerange = source.timerange();
      this.limit = source.limit();
      this.executionState = source.executionState();
      this.filename = source.filename();
      this.timeZone = source.timeZone();
    }
    @Override
    public ResultFormat.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
      if (fieldsInOrder == null) {
        throw new NullPointerException("Null fieldsInOrder");
      }
      this.fieldsInOrder = fieldsInOrder;
      return this;
    }
    @Override
    public ResultFormat.Builder timerange(@Nullable AbsoluteRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public ResultFormat.Builder limit(@Nullable @Positive Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }
    @Override
    public ResultFormat.Builder executionState(ExecutionState executionState) {
      if (executionState == null) {
        throw new NullPointerException("Null executionState");
      }
      this.executionState = executionState;
      return this;
    }
    @Override
    public ResultFormat.Builder filename(@Nullable String filename) {
      this.filename = Optional.ofNullable(filename);
      return this;
    }
    @Override
    public ResultFormat.Builder timeZone(@Nullable DateTimeZone timeZone) {
      this.timeZone = Optional.ofNullable(timeZone);
      return this;
    }
    @Override
    public ResultFormat build() {
      String missing = "";
      if (this.fieldsInOrder == null) {
        missing += " fieldsInOrder";
      }
      if (this.executionState == null) {
        missing += " executionState";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ResultFormat(
          this.fieldsInOrder,
          this.timerange,
          this.limit,
          this.executionState,
          this.filename,
          this.timeZone);
    }
  }

}
