package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryDTO extends QueryDTO {

  private final Optional<String> id;

  private final Optional<TimeRange> timerange;

  private final Optional<Filter> filter;

  private final List<UsedSearchFilter> filters;

  private final Optional<BackendQuery> query;

  private final Set<SearchType> searchTypes;

  private AutoValue_QueryDTO(
      Optional<String> id,
      Optional<TimeRange> timerange,
      Optional<Filter> filter,
      List<UsedSearchFilter> filters,
      Optional<BackendQuery> query,
      Set<SearchType> searchTypes) {
    this.id = id;
    this.timerange = timerange;
    this.filter = filter;
    this.filters = filters;
    this.query = query;
    this.searchTypes = searchTypes;
  }

  @JsonProperty
  @Override
  public Optional<String> id() {
    return id;
  }

  @JsonProperty
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<Filter> filter() {
    return filter;
  }

  @JsonProperty
  @Override
  public List<UsedSearchFilter> filters() {
    return filters;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @Nonnull
  @JsonProperty("search_types")
  @Override
  public Set<SearchType> searchTypes() {
    return searchTypes;
  }

  @Override
  public String toString() {
    return "QueryDTO{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "filter=" + filter + ", "
        + "filters=" + filters + ", "
        + "query=" + query + ", "
        + "searchTypes=" + searchTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryDTO) {
      QueryDTO that = (QueryDTO) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && this.filter.equals(that.filter())
          && this.filters.equals(that.filters())
          && this.query.equals(that.query())
          && this.searchTypes.equals(that.searchTypes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= filters.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    return h$;
  }

  static final class Builder extends QueryDTO.Builder {
    private Optional<String> id = Optional.empty();
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<Filter> filter = Optional.empty();
    private List<UsedSearchFilter> filters;
    private Optional<BackendQuery> query = Optional.empty();
    private Set<SearchType> searchTypes;
    Builder() {
    }
    @Override
    public QueryDTO.Builder id(@Nullable String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }
    @Override
    public QueryDTO.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public QueryDTO.Builder filter(@Nullable Filter filter) {
      this.filter = Optional.ofNullable(filter);
      return this;
    }
    @Override
    public QueryDTO.Builder filters(List<UsedSearchFilter> filters) {
      if (filters == null) {
        throw new NullPointerException("Null filters");
      }
      this.filters = filters;
      return this;
    }
    @Override
    public QueryDTO.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public QueryDTO.Builder searchTypes(Set<SearchType> searchTypes) {
      if (searchTypes == null) {
        throw new NullPointerException("Null searchTypes");
      }
      this.searchTypes = searchTypes;
      return this;
    }
    @Override
    public QueryDTO build() {
      String missing = "";
      if (this.filters == null) {
        missing += " filters";
      }
      if (this.searchTypes == null) {
        missing += " searchTypes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryDTO(
          this.id,
          this.timerange,
          this.filter,
          this.filters,
          this.query,
          this.searchTypes);
    }
  }

}
