package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryDTOv2 extends QueryDTOv2 {

  private final Optional<String> id;

  private final Optional<TimeRange> timerange;

  private final Optional<List<String>> streams;

  private final Optional<List<UsedSearchFilter>> filters;

  private final Optional<BackendQuery> query;

  private final Set<SearchType> searchTypes;

  private AutoValue_QueryDTOv2(
      Optional<String> id,
      Optional<TimeRange> timerange,
      Optional<List<String>> streams,
      Optional<List<UsedSearchFilter>> filters,
      Optional<BackendQuery> query,
      Set<SearchType> searchTypes) {
    this.id = id;
    this.timerange = timerange;
    this.streams = streams;
    this.filters = filters;
    this.query = query;
    this.searchTypes = searchTypes;
  }

  @JsonProperty
  @Override
  public Optional<String> id() {
    return id;
  }

  @JsonProperty
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<List<String>> streams() {
    return streams;
  }

  @JsonProperty
  @Override
  public Optional<List<UsedSearchFilter>> filters() {
    return filters;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @Nonnull
  @JsonProperty("search_types")
  @Override
  public Set<SearchType> searchTypes() {
    return searchTypes;
  }

  @Override
  public String toString() {
    return "QueryDTOv2{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "streams=" + streams + ", "
        + "filters=" + filters + ", "
        + "query=" + query + ", "
        + "searchTypes=" + searchTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryDTOv2) {
      QueryDTOv2 that = (QueryDTOv2) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && this.streams.equals(that.streams())
          && this.filters.equals(that.filters())
          && this.query.equals(that.query())
          && this.searchTypes.equals(that.searchTypes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= filters.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    return h$;
  }

  static final class Builder extends QueryDTOv2.Builder {
    private Optional<String> id = Optional.empty();
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<List<String>> streams = Optional.empty();
    private Optional<List<UsedSearchFilter>> filters = Optional.empty();
    private Optional<BackendQuery> query = Optional.empty();
    private Set<SearchType> searchTypes;
    Builder() {
    }
    @Override
    public QueryDTOv2.Builder id(@Nullable String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }
    @Override
    public QueryDTOv2.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public QueryDTOv2.Builder streams(@Nullable List<String> streams) {
      this.streams = Optional.ofNullable(streams);
      return this;
    }
    @Override
    public QueryDTOv2.Builder filters(@Nullable List<UsedSearchFilter> filters) {
      this.filters = Optional.ofNullable(filters);
      return this;
    }
    @Override
    public QueryDTOv2.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public QueryDTOv2.Builder searchTypes(Set<SearchType> searchTypes) {
      if (searchTypes == null) {
        throw new NullPointerException("Null searchTypes");
      }
      this.searchTypes = searchTypes;
      return this;
    }
    @Override
    public QueryDTOv2 build() {
      String missing = "";
      if (this.searchTypes == null) {
        missing += " searchTypes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryDTOv2(
          this.id,
          this.timerange,
          this.streams,
          this.filters,
          this.query,
          this.searchTypes);
    }
  }

}
