package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValidationRequestDTO extends ValidationRequestDTO {

  private final BackendQuery query;

  private final Optional<BackendQuery> filter;

  private final Optional<TimeRange> timerange;

  private final Optional<Set<String>> streams;

  private final ImmutableSet<Parameter> parameters;

  private final ImmutableMap<String, Parameter.Binding> parameterBindings;

  private final ValidationModeDTO validationMode;

  private AutoValue_ValidationRequestDTO(
      BackendQuery query,
      Optional<BackendQuery> filter,
      Optional<TimeRange> timerange,
      Optional<Set<String>> streams,
      ImmutableSet<Parameter> parameters,
      ImmutableMap<String, Parameter.Binding> parameterBindings,
      ValidationModeDTO validationMode) {
    this.query = query;
    this.filter = filter;
    this.timerange = timerange;
    this.streams = streams;
    this.parameters = parameters;
    this.parameterBindings = parameterBindings;
    this.validationMode = validationMode;
  }

  @JsonProperty
  @Override
  public BackendQuery query() {
    return query;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> filter() {
    return filter;
  }

  @JsonProperty("timerange")
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty("streams")
  @Override
  public Optional<Set<String>> streams() {
    return streams;
  }

  @JsonProperty
  @Override
  public ImmutableSet<Parameter> parameters() {
    return parameters;
  }

  @JsonProperty
  @Override
  public ImmutableMap<String, Parameter.Binding> parameterBindings() {
    return parameterBindings;
  }

  @JsonProperty
  @Override
  public ValidationModeDTO validationMode() {
    return validationMode;
  }

  @Override
  public String toString() {
    return "ValidationRequestDTO{"
        + "query=" + query + ", "
        + "filter=" + filter + ", "
        + "timerange=" + timerange + ", "
        + "streams=" + streams + ", "
        + "parameters=" + parameters + ", "
        + "parameterBindings=" + parameterBindings + ", "
        + "validationMode=" + validationMode
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidationRequestDTO) {
      ValidationRequestDTO that = (ValidationRequestDTO) o;
      return this.query.equals(that.query())
          && this.filter.equals(that.filter())
          && this.timerange.equals(that.timerange())
          && this.streams.equals(that.streams())
          && this.parameters.equals(that.parameters())
          && this.parameterBindings.equals(that.parameterBindings())
          && this.validationMode.equals(that.validationMode());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= parameterBindings.hashCode();
    h$ *= 1000003;
    h$ ^= validationMode.hashCode();
    return h$;
  }

  static final class Builder extends ValidationRequestDTO.Builder {
    private BackendQuery query;
    private Optional<BackendQuery> filter = Optional.empty();
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<Set<String>> streams = Optional.empty();
    private ImmutableSet.Builder<Parameter> parametersBuilder$;
    private ImmutableSet<Parameter> parameters;
    private ImmutableMap.Builder<String, Parameter.Binding> parameterBindingsBuilder$;
    private ImmutableMap<String, Parameter.Binding> parameterBindings;
    private ValidationModeDTO validationMode;
    Builder() {
    }
    @Override
    public ValidationRequestDTO.Builder query(BackendQuery query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public ValidationRequestDTO.Builder filter(@Nullable BackendQuery filter) {
      this.filter = Optional.ofNullable(filter);
      return this;
    }
    @Override
    public ValidationRequestDTO.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public ValidationRequestDTO.Builder streams(@Nullable Set<String> streams) {
      this.streams = Optional.ofNullable(streams);
      return this;
    }
    @Override
    public ImmutableSet.Builder<Parameter> parametersBuilder() {
      if (parametersBuilder$ == null) {
        parametersBuilder$ = ImmutableSet.builder();
      }
      return parametersBuilder$;
    }
    @Override
    public ImmutableMap.Builder<String, Parameter.Binding> parameterBindingsBuilder() {
      if (parameterBindingsBuilder$ == null) {
        parameterBindingsBuilder$ = ImmutableMap.builder();
      }
      return parameterBindingsBuilder$;
    }
    @Override
    public ValidationRequestDTO.Builder validationMode(ValidationModeDTO validationMode) {
      if (validationMode == null) {
        throw new NullPointerException("Null validationMode");
      }
      this.validationMode = validationMode;
      return this;
    }
    @Override
    public ValidationRequestDTO build() {
      if (parametersBuilder$ != null) {
        this.parameters = parametersBuilder$.build();
      } else if (this.parameters == null) {
        this.parameters = ImmutableSet.of();
      }
      if (parameterBindingsBuilder$ != null) {
        this.parameterBindings = parameterBindingsBuilder$.build();
      } else if (this.parameterBindings == null) {
        this.parameterBindings = ImmutableMap.of();
      }
      String missing = "";
      if (this.query == null) {
        missing += " query";
      }
      if (this.validationMode == null) {
        missing += " validationMode";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidationRequestDTO(
          this.query,
          this.filter,
          this.timerange,
          this.streams,
          this.parameters,
          this.parameterBindings,
          this.validationMode);
    }
  }

}
