package org.graylog.plugins.views.search.rest.suggestions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SuggestionsDTO extends SuggestionsDTO {

  private final String field;

  private final String input;

  private final List<SuggestionEntryDTO> suggestions;

  private final SuggestionsErrorDTO error;

  private final Long sumOtherDocsCount;

  private AutoValue_SuggestionsDTO(
      String field,
      String input,
      List<SuggestionEntryDTO> suggestions,
      @Nullable SuggestionsErrorDTO error,
      @Nullable Long sumOtherDocsCount) {
    this.field = field;
    this.input = input;
    this.suggestions = suggestions;
    this.error = error;
    this.sumOtherDocsCount = sumOtherDocsCount;
  }

  @JsonProperty
  @Override
  public String field() {
    return field;
  }

  @JsonProperty
  @Override
  public String input() {
    return input;
  }

  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public List<SuggestionEntryDTO> suggestions() {
    return suggestions;
  }

  @Nullable
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public SuggestionsErrorDTO error() {
    return error;
  }

  @Nullable
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public Long sumOtherDocsCount() {
    return sumOtherDocsCount;
  }

  @Override
  public String toString() {
    return "SuggestionsDTO{"
        + "field=" + field + ", "
        + "input=" + input + ", "
        + "suggestions=" + suggestions + ", "
        + "error=" + error + ", "
        + "sumOtherDocsCount=" + sumOtherDocsCount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SuggestionsDTO) {
      SuggestionsDTO that = (SuggestionsDTO) o;
      return this.field.equals(that.field())
          && this.input.equals(that.input())
          && this.suggestions.equals(that.suggestions())
          && (this.error == null ? that.error() == null : this.error.equals(that.error()))
          && (this.sumOtherDocsCount == null ? that.sumOtherDocsCount() == null : this.sumOtherDocsCount.equals(that.sumOtherDocsCount()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= field.hashCode();
    h$ *= 1000003;
    h$ ^= input.hashCode();
    h$ *= 1000003;
    h$ ^= suggestions.hashCode();
    h$ *= 1000003;
    h$ ^= (error == null) ? 0 : error.hashCode();
    h$ *= 1000003;
    h$ ^= (sumOtherDocsCount == null) ? 0 : sumOtherDocsCount.hashCode();
    return h$;
  }

  static final class Builder extends SuggestionsDTO.Builder {
    private String field;
    private String input;
    private List<SuggestionEntryDTO> suggestions;
    private SuggestionsErrorDTO error;
    private Long sumOtherDocsCount;
    Builder() {
    }
    @Override
    public SuggestionsDTO.Builder field(String field) {
      if (field == null) {
        throw new NullPointerException("Null field");
      }
      this.field = field;
      return this;
    }
    @Override
    public SuggestionsDTO.Builder input(String input) {
      if (input == null) {
        throw new NullPointerException("Null input");
      }
      this.input = input;
      return this;
    }
    @Override
    public SuggestionsDTO.Builder suggestions(List<SuggestionEntryDTO> suggestions) {
      if (suggestions == null) {
        throw new NullPointerException("Null suggestions");
      }
      this.suggestions = suggestions;
      return this;
    }
    @Override
    public SuggestionsDTO.Builder error(@Nullable SuggestionsErrorDTO error) {
      this.error = error;
      return this;
    }
    @Override
    public SuggestionsDTO.Builder sumOtherDocsCount(@Nullable Long sumOtherDocsCount) {
      this.sumOtherDocsCount = sumOtherDocsCount;
      return this;
    }
    @Override
    public SuggestionsDTO build() {
      String missing = "";
      if (this.field == null) {
        missing += " field";
      }
      if (this.input == null) {
        missing += " input";
      }
      if (this.suggestions == null) {
        missing += " suggestions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SuggestionsDTO(
          this.field,
          this.input,
          this.suggestions,
          this.error,
          this.sumOtherDocsCount);
    }
  }

}
