package org.graylog.plugins.views.search.searchfilters.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReferencedQueryStringSearchFilter extends ReferencedQueryStringSearchFilter {

  private final String id;

  private final String title;

  private final String description;

  private final String queryString;

  private final boolean negation;

  private final boolean disabled;

  private AutoValue_ReferencedQueryStringSearchFilter(
      String id,
      @Nullable String title,
      @Nullable String description,
      @Nullable String queryString,
      boolean negation,
      boolean disabled) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.queryString = queryString;
    this.negation = negation;
    this.disabled = disabled;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Nullable
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("queryString")
  @Nullable
  @Override
  public String queryString() {
    return queryString;
  }

  @JsonProperty(value = "negation", defaultValue = "false")
  @Override
  public boolean negation() {
    return negation;
  }

  @JsonProperty(value = "disabled", defaultValue = "false")
  @Override
  public boolean disabled() {
    return disabled;
  }

  @Override
  public String toString() {
    return "ReferencedQueryStringSearchFilter{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "queryString=" + queryString + ", "
        + "negation=" + negation + ", "
        + "disabled=" + disabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReferencedQueryStringSearchFilter) {
      ReferencedQueryStringSearchFilter that = (ReferencedQueryStringSearchFilter) o;
      return this.id.equals(that.id())
          && (this.title == null ? that.title() == null : this.title.equals(that.title()))
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && (this.queryString == null ? that.queryString() == null : this.queryString.equals(that.queryString()))
          && this.negation == that.negation()
          && this.disabled == that.disabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= (title == null) ? 0 : title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= (queryString == null) ? 0 : queryString.hashCode();
    h$ *= 1000003;
    h$ ^= negation ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= disabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public ReferencedQueryStringSearchFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ReferencedQueryStringSearchFilter.Builder {
    private String id;
    private String title;
    private String description;
    private String queryString;
    private Boolean negation;
    private Boolean disabled;
    Builder() {
    }
    private Builder(ReferencedQueryStringSearchFilter source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.queryString = source.queryString();
      this.negation = source.negation();
      this.disabled = source.disabled();
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder title(String title) {
      this.title = title;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder description(String description) {
      this.description = description;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder queryString(String queryString) {
      this.queryString = queryString;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder negation(boolean negation) {
      this.negation = negation;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter.Builder disabled(boolean disabled) {
      this.disabled = disabled;
      return this;
    }
    @Override
    public ReferencedQueryStringSearchFilter build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.negation == null) {
        missing += " negation";
      }
      if (this.disabled == null) {
        missing += " disabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ReferencedQueryStringSearchFilter(
          this.id,
          this.title,
          this.description,
          this.queryString,
          this.negation,
          this.disabled);
    }
  }

}
