package org.graylog.plugins.views.startpage.recentActivities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import org.graylog.grn.GRN;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_RecentActivityDTO extends $AutoValue_RecentActivityDTO {
  AutoValue_RecentActivityDTO(String id, ActivityType activityType, GRN itemGrn, String itemTitle,
      String userName, String grantee, DateTime timestamp) {
    super(id, activityType, itemGrn, itemTitle, userName, grantee, timestamp);
  }

  @JsonIgnore
  @ObjectId
  @Id
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final ActivityType getActivityType() {
    return activityType();
  }

  @JsonIgnore
  public final GRN getItemGrn() {
    return itemGrn();
  }

  @JsonIgnore
  @Nullable
  public final String getItemTitle() {
    return itemTitle();
  }

  @JsonIgnore
  @Nullable
  public final String getUserName() {
    return userName();
  }

  @JsonIgnore
  @Nullable
  public final String getGrantee() {
    return grantee();
  }

  @JsonIgnore
  public final DateTime getTimestamp() {
    return timestamp();
  }
}
