package org.graylog.security.authservice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_AuthServiceBackendDTO extends $AutoValue_AuthServiceBackendDTO {
  AutoValue_AuthServiceBackendDTO(String id, String title, String description,
      Set<String> defaultRoles, AuthServiceBackendConfig config) {
    super(id, title, description, defaultRoles, config);
  }

  @JsonIgnore
  @Id
  @ObjectId
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  public final Set<String> getDefaultRoles() {
    return defaultRoles();
  }

  @JsonIgnore
  @NotNull
  public final AuthServiceBackendConfig getConfig() {
    return config();
  }
}
