package org.graylog.security.authservice.ldap;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.security.encryption.EncryptedValue;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LDAPConnectorConfig extends LDAPConnectorConfig {

  private final Optional<String> systemUsername;

  private final EncryptedValue systemPassword;

  private final ImmutableList<LDAPConnectorConfig.LDAPServer> serverList;

  private final LDAPTransportSecurity transportSecurity;

  private final boolean verifyCertificates;

  private AutoValue_LDAPConnectorConfig(
      Optional<String> systemUsername,
      EncryptedValue systemPassword,
      ImmutableList<LDAPConnectorConfig.LDAPServer> serverList,
      LDAPTransportSecurity transportSecurity,
      boolean verifyCertificates) {
    this.systemUsername = systemUsername;
    this.systemPassword = systemPassword;
    this.serverList = serverList;
    this.transportSecurity = transportSecurity;
    this.verifyCertificates = verifyCertificates;
  }

  @Override
  public Optional<String> systemUsername() {
    return systemUsername;
  }

  @Override
  public EncryptedValue systemPassword() {
    return systemPassword;
  }

  @Override
  public ImmutableList<LDAPConnectorConfig.LDAPServer> serverList() {
    return serverList;
  }

  @Override
  public LDAPTransportSecurity transportSecurity() {
    return transportSecurity;
  }

  @Override
  public boolean verifyCertificates() {
    return verifyCertificates;
  }

  @Override
  public String toString() {
    return "LDAPConnectorConfig{"
        + "systemUsername=" + systemUsername + ", "
        + "systemPassword=" + systemPassword + ", "
        + "serverList=" + serverList + ", "
        + "transportSecurity=" + transportSecurity + ", "
        + "verifyCertificates=" + verifyCertificates
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LDAPConnectorConfig) {
      LDAPConnectorConfig that = (LDAPConnectorConfig) o;
      return this.systemUsername.equals(that.systemUsername())
          && this.systemPassword.equals(that.systemPassword())
          && this.serverList.equals(that.serverList())
          && this.transportSecurity.equals(that.transportSecurity())
          && this.verifyCertificates == that.verifyCertificates();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= systemUsername.hashCode();
    h$ *= 1000003;
    h$ ^= systemPassword.hashCode();
    h$ *= 1000003;
    h$ ^= serverList.hashCode();
    h$ *= 1000003;
    h$ ^= transportSecurity.hashCode();
    h$ *= 1000003;
    h$ ^= verifyCertificates ? 1231 : 1237;
    return h$;
  }

  @Override
  public LDAPConnectorConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends LDAPConnectorConfig.Builder {
    private Optional<String> systemUsername = Optional.empty();
    private EncryptedValue systemPassword;
    private ImmutableList<LDAPConnectorConfig.LDAPServer> serverList;
    private LDAPTransportSecurity transportSecurity;
    private Boolean verifyCertificates;
    Builder() {
    }
    private Builder(LDAPConnectorConfig source) {
      this.systemUsername = source.systemUsername();
      this.systemPassword = source.systemPassword();
      this.serverList = source.serverList();
      this.transportSecurity = source.transportSecurity();
      this.verifyCertificates = source.verifyCertificates();
    }
    @Override
    public LDAPConnectorConfig.Builder systemUsername(@Nullable String systemUsername) {
      this.systemUsername = Optional.ofNullable(systemUsername);
      return this;
    }
    @Override
    public LDAPConnectorConfig.Builder systemPassword(EncryptedValue systemPassword) {
      if (systemPassword == null) {
        throw new NullPointerException("Null systemPassword");
      }
      this.systemPassword = systemPassword;
      return this;
    }
    @Override
    public LDAPConnectorConfig.Builder serverList(List<LDAPConnectorConfig.LDAPServer> serverList) {
      this.serverList = ImmutableList.copyOf(serverList);
      return this;
    }
    @Override
    public LDAPConnectorConfig.Builder transportSecurity(LDAPTransportSecurity transportSecurity) {
      if (transportSecurity == null) {
        throw new NullPointerException("Null transportSecurity");
      }
      this.transportSecurity = transportSecurity;
      return this;
    }
    @Override
    public LDAPConnectorConfig.Builder verifyCertificates(boolean verifyCertificates) {
      this.verifyCertificates = verifyCertificates;
      return this;
    }
    @Override
    public LDAPConnectorConfig build() {
      String missing = "";
      if (this.systemPassword == null) {
        missing += " systemPassword";
      }
      if (this.serverList == null) {
        missing += " serverList";
      }
      if (this.transportSecurity == null) {
        missing += " transportSecurity";
      }
      if (this.verifyCertificates == null) {
        missing += " verifyCertificates";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LDAPConnectorConfig(
          this.systemUsername,
          this.systemPassword,
          this.serverList,
          this.transportSecurity,
          this.verifyCertificates);
    }
  }

}
