package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_InputEntity extends $AutoValue_InputEntity {
  AutoValue_InputEntity(ValueReference title, ReferenceMap configuration,
      Map<String, ValueReference> staticFields, ValueReference type, ValueReference global,
      List<ExtractorEntity> extractors) {
    super(title, configuration, staticFields, type, global, extractors);
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  @NotNull
  public final ReferenceMap getConfiguration() {
    return configuration();
  }

  @JsonIgnore
  @NotNull
  public final Map<String, ValueReference> getStaticFields() {
    return staticFields();
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getType() {
    return type();
  }

  @JsonIgnore
  public final ValueReference getGlobal() {
    return global();
  }

  @JsonIgnore
  @NotNull
  public final List<ExtractorEntity> getExtractors() {
    return extractors();
  }
}
