package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_KeywordRangeEntity extends KeywordRangeEntity {

  private final ModelTypeEntity type;

  private final ValueReference keyword;

  private final ValueReference timezone;

  private AutoValue_KeywordRangeEntity(
      ModelTypeEntity type,
      ValueReference keyword,
      ValueReference timezone) {
    this.type = type;
    this.keyword = keyword;
    this.timezone = timezone;
  }

  @JsonProperty("type")
  @Override
  public ModelTypeEntity type() {
    return type;
  }

  @JsonProperty("keyword")
  @Override
  public ValueReference keyword() {
    return keyword;
  }

  @JsonProperty("timezone")
  @Override
  public ValueReference timezone() {
    return timezone;
  }

  @Override
  public String toString() {
    return "KeywordRangeEntity{"
        + "type=" + type + ", "
        + "keyword=" + keyword + ", "
        + "timezone=" + timezone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof KeywordRangeEntity) {
      KeywordRangeEntity that = (KeywordRangeEntity) o;
      return this.type.equals(that.type())
          && this.keyword.equals(that.keyword())
          && this.timezone.equals(that.timezone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= keyword.hashCode();
    h$ *= 1000003;
    h$ ^= timezone.hashCode();
    return h$;
  }

  static final class Builder extends KeywordRangeEntity.Builder {
    private ModelTypeEntity type;
    private ValueReference keyword;
    private ValueReference timezone;
    Builder() {
    }
    @Override
    public KeywordRangeEntity.Builder type(ModelTypeEntity type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    KeywordRangeEntity.Builder keyword(ValueReference keyword) {
      if (keyword == null) {
        throw new NullPointerException("Null keyword");
      }
      this.keyword = keyword;
      return this;
    }
    @Override
    KeywordRangeEntity.Builder timezone(ValueReference timezone) {
      if (timezone == null) {
        throw new NullPointerException("Null timezone");
      }
      this.timezone = timezone;
      return this;
    }
    @Override
    KeywordRangeEntity autoBuild() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.keyword == null) {
        missing += " keyword";
      }
      if (this.timezone == null) {
        missing += " timezone";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_KeywordRangeEntity(
          this.type,
          this.keyword,
          this.timezone);
    }
  }

}
