package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.Nullable;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_LookupCacheEntity extends $AutoValue_LookupCacheEntity {
  AutoValue_LookupCacheEntity(ValueReference scope, ValueReference name, ValueReference title,
      ValueReference description, ReferenceMap configuration) {
    super(scope, name, title, description, configuration);
  }

  @JsonIgnore
  @Nullable
  public final ValueReference getScope() {
    return scope();
  }

  @JsonIgnore
  public final ValueReference getName() {
    return name();
  }

  @JsonIgnore
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  public final ValueReference getDescription() {
    return description();
  }

  @JsonIgnore
  public final ReferenceMap getConfiguration() {
    return configuration();
  }
}
