package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SearchEntity extends SearchEntity {

  private final ImmutableSet<QueryEntity> queries;

  private final ImmutableSet<Parameter> parameters;

  private final Map<String, PluginMetadataSummary> requires;

  private final Optional<String> owner;

  private final DateTime createdAt;

  private AutoValue_SearchEntity(
      ImmutableSet<QueryEntity> queries,
      ImmutableSet<Parameter> parameters,
      Map<String, PluginMetadataSummary> requires,
      Optional<String> owner,
      DateTime createdAt) {
    this.queries = queries;
    this.parameters = parameters;
    this.requires = requires;
    this.owner = owner;
    this.createdAt = createdAt;
  }

  @JsonProperty
  @Override
  public ImmutableSet<QueryEntity> queries() {
    return queries;
  }

  @JsonProperty
  @Override
  public ImmutableSet<Parameter> parameters() {
    return parameters;
  }

  @JsonProperty("requires")
  @Override
  public Map<String, PluginMetadataSummary> requires() {
    return requires;
  }

  @JsonProperty("owner")
  @Override
  public Optional<String> owner() {
    return owner;
  }

  @JsonProperty("created_at")
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @Override
  public String toString() {
    return "SearchEntity{"
        + "queries=" + queries + ", "
        + "parameters=" + parameters + ", "
        + "requires=" + requires + ", "
        + "owner=" + owner + ", "
        + "createdAt=" + createdAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchEntity) {
      SearchEntity that = (SearchEntity) o;
      return this.queries.equals(that.queries())
          && this.parameters.equals(that.parameters())
          && this.requires.equals(that.requires())
          && this.owner.equals(that.owner())
          && this.createdAt.equals(that.createdAt());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= queries.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= requires.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    return h$;
  }

  @Override
  public SearchEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SearchEntity.Builder {
    private ImmutableSet<QueryEntity> queries;
    private ImmutableSet<Parameter> parameters;
    private Map<String, PluginMetadataSummary> requires;
    private Optional<String> owner = Optional.empty();
    private DateTime createdAt;
    Builder() {
    }
    private Builder(SearchEntity source) {
      this.queries = source.queries();
      this.parameters = source.parameters();
      this.requires = source.requires();
      this.owner = source.owner();
      this.createdAt = source.createdAt();
    }
    @Override
    public SearchEntity.Builder queries(ImmutableSet<QueryEntity> queries) {
      if (queries == null) {
        throw new NullPointerException("Null queries");
      }
      this.queries = queries;
      return this;
    }
    @Override
    public SearchEntity.Builder parameters(ImmutableSet<Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public SearchEntity.Builder requires(Map<String, PluginMetadataSummary> requires) {
      if (requires == null) {
        throw new NullPointerException("Null requires");
      }
      this.requires = requires;
      return this;
    }
    @Override
    public SearchEntity.Builder owner(@Nullable String owner) {
      this.owner = Optional.ofNullable(owner);
      return this;
    }
    @Override
    public SearchEntity.Builder createdAt(DateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public SearchEntity build() {
      String missing = "";
      if (this.queries == null) {
        missing += " queries";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.requires == null) {
        missing += " requires";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SearchEntity(
          this.queries,
          this.parameters,
          this.requires,
          this.owner,
          this.createdAt);
    }
  }

}
