package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;

final class AutoValue_ViewEntity extends $AutoValue_ViewEntity {
  AutoValue_ViewEntity(ViewEntity.Type type, ValueReference title, ValueReference summary,
      ValueReference description, SearchEntity search, ImmutableSet<String> properties,
      Map<String, PluginMetadataSummary> requires, Map<String, ViewStateEntity> state,
      Optional<String> owner, DateTime createdAt) {
    super(type, title, summary, description, search, properties, requires, state, owner, createdAt);
  }

  @JsonIgnore
  public final ViewEntity.Type getType() {
    return type();
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  public final ValueReference getSummary() {
    return summary();
  }

  @JsonIgnore
  public final ValueReference getDescription() {
    return description();
  }

  @JsonIgnore
  public final SearchEntity getSearch() {
    return search();
  }

  @JsonIgnore
  public final ImmutableSet<String> getProperties() {
    return properties();
  }

  @JsonIgnore
  public final Map<String, PluginMetadataSummary> getRequires() {
    return requires();
  }

  @JsonIgnore
  public final Map<String, ViewStateEntity> getState() {
    return state();
  }

  @JsonIgnore
  public final Optional<String> getOwner() {
    return owner();
  }

  @JsonIgnore
  public final DateTime getCreatedAt() {
    return createdAt();
  }
}
