package org.graylog2.indexer.searches;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.joda.time.Period;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_SearchesClusterConfig extends SearchesClusterConfig {

  private final Period queryTimeRangeLimit;

  private final Map<Period, String> relativeTimerangeOptions;

  private final Map<Period, String> surroundingTimerangeOptions;

  private final Set<String> surroundingFilterFields;

  private final Set<String> analysisDisabledFields;

  private final Map<Period, String> autoRefreshTimerangeOptions;

  private final Period defaultAutoRefreshOption;

  $AutoValue_SearchesClusterConfig(
      Period queryTimeRangeLimit,
      Map<Period, String> relativeTimerangeOptions,
      Map<Period, String> surroundingTimerangeOptions,
      Set<String> surroundingFilterFields,
      Set<String> analysisDisabledFields,
      Map<Period, String> autoRefreshTimerangeOptions,
      Period defaultAutoRefreshOption) {
    if (queryTimeRangeLimit == null) {
      throw new NullPointerException("Null queryTimeRangeLimit");
    }
    this.queryTimeRangeLimit = queryTimeRangeLimit;
    if (relativeTimerangeOptions == null) {
      throw new NullPointerException("Null relativeTimerangeOptions");
    }
    this.relativeTimerangeOptions = relativeTimerangeOptions;
    if (surroundingTimerangeOptions == null) {
      throw new NullPointerException("Null surroundingTimerangeOptions");
    }
    this.surroundingTimerangeOptions = surroundingTimerangeOptions;
    if (surroundingFilterFields == null) {
      throw new NullPointerException("Null surroundingFilterFields");
    }
    this.surroundingFilterFields = surroundingFilterFields;
    if (analysisDisabledFields == null) {
      throw new NullPointerException("Null analysisDisabledFields");
    }
    this.analysisDisabledFields = analysisDisabledFields;
    if (autoRefreshTimerangeOptions == null) {
      throw new NullPointerException("Null autoRefreshTimerangeOptions");
    }
    this.autoRefreshTimerangeOptions = autoRefreshTimerangeOptions;
    if (defaultAutoRefreshOption == null) {
      throw new NullPointerException("Null defaultAutoRefreshOption");
    }
    this.defaultAutoRefreshOption = defaultAutoRefreshOption;
  }

  @JsonProperty("query_time_range_limit")
  @Override
  public Period queryTimeRangeLimit() {
    return queryTimeRangeLimit;
  }

  @JsonProperty("relative_timerange_options")
  @Override
  public Map<Period, String> relativeTimerangeOptions() {
    return relativeTimerangeOptions;
  }

  @JsonProperty("surrounding_timerange_options")
  @Override
  public Map<Period, String> surroundingTimerangeOptions() {
    return surroundingTimerangeOptions;
  }

  @JsonProperty("surrounding_filter_fields")
  @Override
  public Set<String> surroundingFilterFields() {
    return surroundingFilterFields;
  }

  @JsonProperty("analysis_disabled_fields")
  @Override
  public Set<String> analysisDisabledFields() {
    return analysisDisabledFields;
  }

  @JsonProperty("auto_refresh_timerange_options")
  @Override
  public Map<Period, String> autoRefreshTimerangeOptions() {
    return autoRefreshTimerangeOptions;
  }

  @JsonProperty("default_auto_refresh_option")
  @Override
  public Period defaultAutoRefreshOption() {
    return defaultAutoRefreshOption;
  }

  @Override
  public String toString() {
    return "SearchesClusterConfig{"
        + "queryTimeRangeLimit=" + queryTimeRangeLimit + ", "
        + "relativeTimerangeOptions=" + relativeTimerangeOptions + ", "
        + "surroundingTimerangeOptions=" + surroundingTimerangeOptions + ", "
        + "surroundingFilterFields=" + surroundingFilterFields + ", "
        + "analysisDisabledFields=" + analysisDisabledFields + ", "
        + "autoRefreshTimerangeOptions=" + autoRefreshTimerangeOptions + ", "
        + "defaultAutoRefreshOption=" + defaultAutoRefreshOption
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchesClusterConfig) {
      SearchesClusterConfig that = (SearchesClusterConfig) o;
      return this.queryTimeRangeLimit.equals(that.queryTimeRangeLimit())
          && this.relativeTimerangeOptions.equals(that.relativeTimerangeOptions())
          && this.surroundingTimerangeOptions.equals(that.surroundingTimerangeOptions())
          && this.surroundingFilterFields.equals(that.surroundingFilterFields())
          && this.analysisDisabledFields.equals(that.analysisDisabledFields())
          && this.autoRefreshTimerangeOptions.equals(that.autoRefreshTimerangeOptions())
          && this.defaultAutoRefreshOption.equals(that.defaultAutoRefreshOption());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= queryTimeRangeLimit.hashCode();
    h$ *= 1000003;
    h$ ^= relativeTimerangeOptions.hashCode();
    h$ *= 1000003;
    h$ ^= surroundingTimerangeOptions.hashCode();
    h$ *= 1000003;
    h$ ^= surroundingFilterFields.hashCode();
    h$ *= 1000003;
    h$ ^= analysisDisabledFields.hashCode();
    h$ *= 1000003;
    h$ ^= autoRefreshTimerangeOptions.hashCode();
    h$ *= 1000003;
    h$ ^= defaultAutoRefreshOption.hashCode();
    return h$;
  }

  @Override
  public SearchesClusterConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends SearchesClusterConfig.Builder {
    private Period queryTimeRangeLimit;
    private Map<Period, String> relativeTimerangeOptions;
    private Map<Period, String> surroundingTimerangeOptions;
    private Set<String> surroundingFilterFields;
    private Set<String> analysisDisabledFields;
    private Map<Period, String> autoRefreshTimerangeOptions;
    private Period defaultAutoRefreshOption;
    Builder() {
    }
    private Builder(SearchesClusterConfig source) {
      this.queryTimeRangeLimit = source.queryTimeRangeLimit();
      this.relativeTimerangeOptions = source.relativeTimerangeOptions();
      this.surroundingTimerangeOptions = source.surroundingTimerangeOptions();
      this.surroundingFilterFields = source.surroundingFilterFields();
      this.analysisDisabledFields = source.analysisDisabledFields();
      this.autoRefreshTimerangeOptions = source.autoRefreshTimerangeOptions();
      this.defaultAutoRefreshOption = source.defaultAutoRefreshOption();
    }
    @Override
    public SearchesClusterConfig.Builder queryTimeRangeLimit(Period queryTimeRangeLimit) {
      if (queryTimeRangeLimit == null) {
        throw new NullPointerException("Null queryTimeRangeLimit");
      }
      this.queryTimeRangeLimit = queryTimeRangeLimit;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder relativeTimerangeOptions(Map<Period, String> relativeTimerangeOptions) {
      if (relativeTimerangeOptions == null) {
        throw new NullPointerException("Null relativeTimerangeOptions");
      }
      this.relativeTimerangeOptions = relativeTimerangeOptions;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder surroundingTimerangeOptions(Map<Period, String> surroundingTimerangeOptions) {
      if (surroundingTimerangeOptions == null) {
        throw new NullPointerException("Null surroundingTimerangeOptions");
      }
      this.surroundingTimerangeOptions = surroundingTimerangeOptions;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder surroundingFilterFields(Set<String> surroundingFilterFields) {
      if (surroundingFilterFields == null) {
        throw new NullPointerException("Null surroundingFilterFields");
      }
      this.surroundingFilterFields = surroundingFilterFields;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder analysisDisabledFields(Set<String> analysisDisabledFields) {
      if (analysisDisabledFields == null) {
        throw new NullPointerException("Null analysisDisabledFields");
      }
      this.analysisDisabledFields = analysisDisabledFields;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder autoRefreshTimerangeOptions(Map<Period, String> autoRefreshTimerangeOptions) {
      if (autoRefreshTimerangeOptions == null) {
        throw new NullPointerException("Null autoRefreshTimerangeOptions");
      }
      this.autoRefreshTimerangeOptions = autoRefreshTimerangeOptions;
      return this;
    }
    @Override
    public SearchesClusterConfig.Builder defaultAutoRefreshOption(Period defaultAutoRefreshOption) {
      if (defaultAutoRefreshOption == null) {
        throw new NullPointerException("Null defaultAutoRefreshOption");
      }
      this.defaultAutoRefreshOption = defaultAutoRefreshOption;
      return this;
    }
    @Override
    public SearchesClusterConfig build() {
      String missing = "";
      if (this.queryTimeRangeLimit == null) {
        missing += " queryTimeRangeLimit";
      }
      if (this.relativeTimerangeOptions == null) {
        missing += " relativeTimerangeOptions";
      }
      if (this.surroundingTimerangeOptions == null) {
        missing += " surroundingTimerangeOptions";
      }
      if (this.surroundingFilterFields == null) {
        missing += " surroundingFilterFields";
      }
      if (this.analysisDisabledFields == null) {
        missing += " analysisDisabledFields";
      }
      if (this.autoRefreshTimerangeOptions == null) {
        missing += " autoRefreshTimerangeOptions";
      }
      if (this.defaultAutoRefreshOption == null) {
        missing += " defaultAutoRefreshOption";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SearchesClusterConfig(
          this.queryTimeRangeLimit,
          this.relativeTimerangeOptions,
          this.surroundingTimerangeOptions,
          this.surroundingFilterFields,
          this.analysisDisabledFields,
          this.autoRefreshTimerangeOptions,
          this.defaultAutoRefreshOption);
    }
  }

}
