package org.graylog2.indexer.searches;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.Map;
import java.util.Set;
import org.joda.time.Period;

final class AutoValue_SearchesClusterConfig extends $AutoValue_SearchesClusterConfig {
  AutoValue_SearchesClusterConfig(Period queryTimeRangeLimit,
      Map<Period, String> relativeTimerangeOptions, Map<Period, String> surroundingTimerangeOptions,
      Set<String> surroundingFilterFields, Set<String> analysisDisabledFields,
      Map<Period, String> autoRefreshTimerangeOptions, Period defaultAutoRefreshOption) {
    super(queryTimeRangeLimit, relativeTimerangeOptions, surroundingTimerangeOptions, surroundingFilterFields, analysisDisabledFields, autoRefreshTimerangeOptions, defaultAutoRefreshOption);
  }

  @JsonIgnore
  public final Period getQueryTimeRangeLimit() {
    return queryTimeRangeLimit();
  }

  @JsonIgnore
  public final Map<Period, String> getRelativeTimerangeOptions() {
    return relativeTimerangeOptions();
  }

  @JsonIgnore
  public final Map<Period, String> getSurroundingTimerangeOptions() {
    return surroundingTimerangeOptions();
  }

  @JsonIgnore
  public final Set<String> getSurroundingFilterFields() {
    return surroundingFilterFields();
  }

  @JsonIgnore
  public final Set<String> getAnalysisDisabledFields() {
    return analysisDisabledFields();
  }

  @JsonIgnore
  public final Map<Period, String> getAutoRefreshTimerangeOptions() {
    return autoRefreshTimerangeOptions();
  }

  @JsonIgnore
  public final Period getDefaultAutoRefreshOption() {
    return defaultAutoRefreshOption();
  }
}
