package org.graylog2.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LookupDefaultMultiValue extends LookupDefaultMultiValue {

  private final String valueString;

  private final LookupDefaultValue.Type valueType;

  private final Map<Object, Object> value;

  private AutoValue_LookupDefaultMultiValue(
      String valueString,
      LookupDefaultValue.Type valueType,
      @Nullable Map<Object, Object> value) {
    this.valueString = valueString;
    this.valueType = valueType;
    this.value = value;
  }

  @JsonProperty("value_string")
  @Override
  public String valueString() {
    return valueString;
  }

  @JsonProperty("value_type")
  @Override
  public LookupDefaultValue.Type valueType() {
    return valueType;
  }

  @JsonProperty("value")
  @Nullable
  @Override
  public Map<Object, Object> value() {
    return value;
  }

  @Override
  public String toString() {
    return "LookupDefaultMultiValue{"
        + "valueString=" + valueString + ", "
        + "valueType=" + valueType + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LookupDefaultMultiValue) {
      LookupDefaultMultiValue that = (LookupDefaultMultiValue) o;
      return this.valueString.equals(that.valueString())
          && this.valueType.equals(that.valueType())
          && (this.value == null ? that.value() == null : this.value.equals(that.value()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= valueString.hashCode();
    h$ *= 1000003;
    h$ ^= valueType.hashCode();
    h$ *= 1000003;
    h$ ^= (value == null) ? 0 : value.hashCode();
    return h$;
  }

  @Override
  public LookupDefaultMultiValue.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends LookupDefaultMultiValue.Builder {
    private String valueString;
    private LookupDefaultValue.Type valueType;
    private Map<Object, Object> value;
    Builder() {
    }
    private Builder(LookupDefaultMultiValue source) {
      this.valueString = source.valueString();
      this.valueType = source.valueType();
      this.value = source.value();
    }
    @Override
    public LookupDefaultMultiValue.Builder valueString(String valueString) {
      if (valueString == null) {
        throw new NullPointerException("Null valueString");
      }
      this.valueString = valueString;
      return this;
    }
    @Override
    public LookupDefaultMultiValue.Builder valueType(LookupDefaultValue.Type valueType) {
      if (valueType == null) {
        throw new NullPointerException("Null valueType");
      }
      this.valueType = valueType;
      return this;
    }
    @Override
    public LookupDefaultMultiValue.Builder value(@Nullable Map<Object, Object> value) {
      this.value = value;
      return this;
    }
    @Override
    public LookupDefaultMultiValue build() {
      String missing = "";
      if (this.valueString == null) {
        missing += " valueString";
      }
      if (this.valueType == null) {
        missing += " valueType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LookupDefaultMultiValue(
          this.valueString,
          this.valueType,
          this.value);
    }
  }

}
