package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_DSVHTTPDataAdapter_Config extends DSVHTTPDataAdapter.Config {

  private final String type;

  private final @NotEmpty String url;

  private final @Size(min = 1, max = 1) @NotEmpty String separator;

  private final @Size(min = 1, max = 1) @NotEmpty String lineSeparator;

  private final @Size(min = 1, max = 1) @NotEmpty String quotechar;

  private final @Size(min = 1) @NotEmpty String ignorechar;

  private final @NotEmpty Integer keyColumn;

  private final Optional<Boolean> checkPresenceOnly;

  private final @NotEmpty Optional<Integer> valueColumn;

  private final @Min(1L) long refreshInterval;

  private final Optional<Boolean> caseInsensitiveLookup;

  $AutoValue_DSVHTTPDataAdapter_Config(
      String type,
      @NotEmpty String url,
      @Size(min = 1, max = 1) @NotEmpty String separator,
      @Size(min = 1, max = 1) @NotEmpty String lineSeparator,
      @Size(min = 1, max = 1) @NotEmpty String quotechar,
      @Size(min = 1) @NotEmpty String ignorechar,
      @NotEmpty Integer keyColumn,
      Optional<Boolean> checkPresenceOnly,
      @NotEmpty Optional<Integer> valueColumn,
      @Min(1L) long refreshInterval,
      Optional<Boolean> caseInsensitiveLookup) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (url == null) {
      throw new NullPointerException("Null url");
    }
    this.url = url;
    if (separator == null) {
      throw new NullPointerException("Null separator");
    }
    this.separator = separator;
    if (lineSeparator == null) {
      throw new NullPointerException("Null lineSeparator");
    }
    this.lineSeparator = lineSeparator;
    if (quotechar == null) {
      throw new NullPointerException("Null quotechar");
    }
    this.quotechar = quotechar;
    if (ignorechar == null) {
      throw new NullPointerException("Null ignorechar");
    }
    this.ignorechar = ignorechar;
    if (keyColumn == null) {
      throw new NullPointerException("Null keyColumn");
    }
    this.keyColumn = keyColumn;
    if (checkPresenceOnly == null) {
      throw new NullPointerException("Null checkPresenceOnly");
    }
    this.checkPresenceOnly = checkPresenceOnly;
    if (valueColumn == null) {
      throw new NullPointerException("Null valueColumn");
    }
    this.valueColumn = valueColumn;
    this.refreshInterval = refreshInterval;
    if (caseInsensitiveLookup == null) {
      throw new NullPointerException("Null caseInsensitiveLookup");
    }
    this.caseInsensitiveLookup = caseInsensitiveLookup;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("url")
  @Override
  public @NotEmpty String url() {
    return url;
  }

  @JsonProperty("separator")
  @Override
  public @Size(min = 1, max = 1) @NotEmpty String separator() {
    return separator;
  }

  @JsonProperty("line_separator")
  @Override
  public @Size(min = 1, max = 1) @NotEmpty String lineSeparator() {
    return lineSeparator;
  }

  @JsonProperty("quotechar")
  @Override
  public @Size(min = 1, max = 1) @NotEmpty String quotechar() {
    return quotechar;
  }

  @JsonProperty("ignorechar")
  @Override
  public @Size(min = 1) @NotEmpty String ignorechar() {
    return ignorechar;
  }

  @JsonProperty("key_column")
  @Override
  public @NotEmpty Integer keyColumn() {
    return keyColumn;
  }

  @JsonProperty("check_presence_only")
  @Override
  public Optional<Boolean> checkPresenceOnly() {
    return checkPresenceOnly;
  }

  @JsonProperty("value_column")
  @Override
  public @NotEmpty Optional<Integer> valueColumn() {
    return valueColumn;
  }

  @JsonProperty("refresh_interval")
  @Override
  public @Min(1L) long refreshInterval() {
    return refreshInterval;
  }

  @JsonProperty("case_insensitive_lookup")
  @Override
  public Optional<Boolean> caseInsensitiveLookup() {
    return caseInsensitiveLookup;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "url=" + url + ", "
        + "separator=" + separator + ", "
        + "lineSeparator=" + lineSeparator + ", "
        + "quotechar=" + quotechar + ", "
        + "ignorechar=" + ignorechar + ", "
        + "keyColumn=" + keyColumn + ", "
        + "checkPresenceOnly=" + checkPresenceOnly + ", "
        + "valueColumn=" + valueColumn + ", "
        + "refreshInterval=" + refreshInterval + ", "
        + "caseInsensitiveLookup=" + caseInsensitiveLookup
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DSVHTTPDataAdapter.Config) {
      DSVHTTPDataAdapter.Config that = (DSVHTTPDataAdapter.Config) o;
      return this.type.equals(that.type())
          && this.url.equals(that.url())
          && this.separator.equals(that.separator())
          && this.lineSeparator.equals(that.lineSeparator())
          && this.quotechar.equals(that.quotechar())
          && this.ignorechar.equals(that.ignorechar())
          && this.keyColumn.equals(that.keyColumn())
          && this.checkPresenceOnly.equals(that.checkPresenceOnly())
          && this.valueColumn.equals(that.valueColumn())
          && this.refreshInterval == that.refreshInterval()
          && this.caseInsensitiveLookup.equals(that.caseInsensitiveLookup());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= url.hashCode();
    h$ *= 1000003;
    h$ ^= separator.hashCode();
    h$ *= 1000003;
    h$ ^= lineSeparator.hashCode();
    h$ *= 1000003;
    h$ ^= quotechar.hashCode();
    h$ *= 1000003;
    h$ ^= ignorechar.hashCode();
    h$ *= 1000003;
    h$ ^= keyColumn.hashCode();
    h$ *= 1000003;
    h$ ^= checkPresenceOnly.hashCode();
    h$ *= 1000003;
    h$ ^= valueColumn.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((refreshInterval >>> 32) ^ refreshInterval);
    h$ *= 1000003;
    h$ ^= caseInsensitiveLookup.hashCode();
    return h$;
  }

  static class Builder extends DSVHTTPDataAdapter.Config.Builder {
    private String type;
    private @NotEmpty String url;
    private @Size(min = 1, max = 1) @NotEmpty String separator;
    private @Size(min = 1, max = 1) @NotEmpty String lineSeparator;
    private @Size(min = 1, max = 1) @NotEmpty String quotechar;
    private @Size(min = 1) @NotEmpty String ignorechar;
    private @NotEmpty Integer keyColumn;
    private Optional<Boolean> checkPresenceOnly = Optional.empty();
    private @NotEmpty Optional<Integer> valueColumn = Optional.empty();
    private Long refreshInterval;
    private Optional<Boolean> caseInsensitiveLookup = Optional.empty();
    Builder() {
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder url(String url) {
      if (url == null) {
        throw new NullPointerException("Null url");
      }
      this.url = url;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder separator(String separator) {
      if (separator == null) {
        throw new NullPointerException("Null separator");
      }
      this.separator = separator;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder lineSeparator(String lineSeparator) {
      if (lineSeparator == null) {
        throw new NullPointerException("Null lineSeparator");
      }
      this.lineSeparator = lineSeparator;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder quotechar(String quotechar) {
      if (quotechar == null) {
        throw new NullPointerException("Null quotechar");
      }
      this.quotechar = quotechar;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder ignorechar(String ignorechar) {
      if (ignorechar == null) {
        throw new NullPointerException("Null ignorechar");
      }
      this.ignorechar = ignorechar;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder keyColumn(Integer keyColumn) {
      if (keyColumn == null) {
        throw new NullPointerException("Null keyColumn");
      }
      this.keyColumn = keyColumn;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder checkPresenceOnly(Boolean checkPresenceOnly) {
      this.checkPresenceOnly = Optional.of(checkPresenceOnly);
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder valueColumn(Integer valueColumn) {
      this.valueColumn = Optional.of(valueColumn);
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder refreshInterval(long refreshInterval) {
      this.refreshInterval = refreshInterval;
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config.Builder caseInsensitiveLookup(Boolean caseInsensitiveLookup) {
      this.caseInsensitiveLookup = Optional.of(caseInsensitiveLookup);
      return this;
    }
    @Override
    public DSVHTTPDataAdapter.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.url == null) {
        missing += " url";
      }
      if (this.separator == null) {
        missing += " separator";
      }
      if (this.lineSeparator == null) {
        missing += " lineSeparator";
      }
      if (this.quotechar == null) {
        missing += " quotechar";
      }
      if (this.ignorechar == null) {
        missing += " ignorechar";
      }
      if (this.keyColumn == null) {
        missing += " keyColumn";
      }
      if (this.refreshInterval == null) {
        missing += " refreshInterval";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DSVHTTPDataAdapter_Config(
          this.type,
          this.url,
          this.separator,
          this.lineSeparator,
          this.quotechar,
          this.ignorechar,
          this.keyColumn,
          this.checkPresenceOnly,
          this.valueColumn,
          this.refreshInterval,
          this.caseInsensitiveLookup);
    }
  }

}
