package org.graylog2.rest.models.search.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_TermsHistogramResult extends TermsHistogramResult {

  private final long time;

  private final String interval;

  private final long size;

  private final Map<Long, TermsResult> buckets;

  private final Set<String> terms;

  private final String builtQuery;

  private final TimeRange queriedTimerange;

  $AutoValue_TermsHistogramResult(
      long time,
      String interval,
      long size,
      Map<Long, TermsResult> buckets,
      Set<String> terms,
      String builtQuery,
      TimeRange queriedTimerange) {
    this.time = time;
    if (interval == null) {
      throw new NullPointerException("Null interval");
    }
    this.interval = interval;
    this.size = size;
    if (buckets == null) {
      throw new NullPointerException("Null buckets");
    }
    this.buckets = buckets;
    if (terms == null) {
      throw new NullPointerException("Null terms");
    }
    this.terms = terms;
    if (builtQuery == null) {
      throw new NullPointerException("Null builtQuery");
    }
    this.builtQuery = builtQuery;
    if (queriedTimerange == null) {
      throw new NullPointerException("Null queriedTimerange");
    }
    this.queriedTimerange = queriedTimerange;
  }

  @JsonProperty("time")
  @Override
  public long time() {
    return time;
  }

  @JsonProperty("interval")
  @Override
  public String interval() {
    return interval;
  }

  @JsonProperty("size")
  @Override
  public long size() {
    return size;
  }

  @JsonProperty("buckets")
  @Override
  public Map<Long, TermsResult> buckets() {
    return buckets;
  }

  @JsonProperty("terms")
  @Override
  public Set<String> terms() {
    return terms;
  }

  @JsonProperty("built_query")
  @Override
  public String builtQuery() {
    return builtQuery;
  }

  @JsonProperty("queried_timerange")
  @Override
  public TimeRange queriedTimerange() {
    return queriedTimerange;
  }

  @Override
  public String toString() {
    return "TermsHistogramResult{"
        + "time=" + time + ", "
        + "interval=" + interval + ", "
        + "size=" + size + ", "
        + "buckets=" + buckets + ", "
        + "terms=" + terms + ", "
        + "builtQuery=" + builtQuery + ", "
        + "queriedTimerange=" + queriedTimerange
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TermsHistogramResult) {
      TermsHistogramResult that = (TermsHistogramResult) o;
      return this.time == that.time()
          && this.interval.equals(that.interval())
          && this.size == that.size()
          && this.buckets.equals(that.buckets())
          && this.terms.equals(that.terms())
          && this.builtQuery.equals(that.builtQuery())
          && this.queriedTimerange.equals(that.queriedTimerange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((time >>> 32) ^ time);
    h$ *= 1000003;
    h$ ^= interval.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((size >>> 32) ^ size);
    h$ *= 1000003;
    h$ ^= buckets.hashCode();
    h$ *= 1000003;
    h$ ^= terms.hashCode();
    h$ *= 1000003;
    h$ ^= builtQuery.hashCode();
    h$ *= 1000003;
    h$ ^= queriedTimerange.hashCode();
    return h$;
  }

}
