package org.graylog2.rest.models.system.lookup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;

final class AutoValue_DataAdapterApi extends $AutoValue_DataAdapterApi {
  AutoValue_DataAdapterApi(String id, String scope, String title, String description, String name,
      Boolean customErrorTTLEnabled, Long customErrorTTL, TimeUnit customErrorTTLUnit,
      String contentPack, LookupDataAdapterConfiguration config) {
    super(id, scope, title, description, name, customErrorTTLEnabled, customErrorTTL, customErrorTTLUnit, contentPack, config);
  }

  @JsonIgnore
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  @Nullable
  public final String getScope() {
    return scope();
  }

  @JsonIgnore
  @NotEmpty
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  @NotEmpty
  public final String getName() {
    return name();
  }

  @JsonIgnore
  @Nullable
  public final Boolean isCustomErrorTTLEnabled() {
    return customErrorTTLEnabled();
  }

  @JsonIgnore
  @Nullable
  public final Long getCustomErrorTTL() {
    return customErrorTTL();
  }

  @JsonIgnore
  @Nullable
  public final TimeUnit getCustomErrorTTLUnit() {
    return customErrorTTLUnit();
  }

  @JsonIgnore
  @Nullable
  public final String getContentPack() {
    return contentPack();
  }

  @JsonIgnore
  @NotNull
  public final LookupDataAdapterConfiguration getConfig() {
    return config();
  }
}
