package org.graylog2.rest.models.users.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_CreateUserRequest extends CreateUserRequest {

  private final String username;

  private final String password;

  private final String email;

  private final String firstName;

  private final String lastName;

  private final List<String> permissions;

  private final String timezone;

  private final Long sessionTimeoutMs;

  private final Startpage startpage;

  private final List<String> roles;

  private final boolean isServiceAccount;

  $AutoValue_CreateUserRequest(
      String username,
      String password,
      String email,
      String firstName,
      String lastName,
      List<String> permissions,
      @Nullable String timezone,
      @Nullable Long sessionTimeoutMs,
      @Nullable Startpage startpage,
      @Nullable List<String> roles,
      boolean isServiceAccount) {
    if (username == null) {
      throw new NullPointerException("Null username");
    }
    this.username = username;
    if (password == null) {
      throw new NullPointerException("Null password");
    }
    this.password = password;
    if (email == null) {
      throw new NullPointerException("Null email");
    }
    this.email = email;
    if (firstName == null) {
      throw new NullPointerException("Null firstName");
    }
    this.firstName = firstName;
    if (lastName == null) {
      throw new NullPointerException("Null lastName");
    }
    this.lastName = lastName;
    if (permissions == null) {
      throw new NullPointerException("Null permissions");
    }
    this.permissions = permissions;
    this.timezone = timezone;
    this.sessionTimeoutMs = sessionTimeoutMs;
    this.startpage = startpage;
    this.roles = roles;
    this.isServiceAccount = isServiceAccount;
  }

  @JsonProperty
  @Override
  public String username() {
    return username;
  }

  @JsonProperty
  @Override
  public String password() {
    return password;
  }

  @JsonProperty
  @Override
  public String email() {
    return email;
  }

  @JsonProperty
  @Override
  public String firstName() {
    return firstName;
  }

  @JsonProperty
  @Override
  public String lastName() {
    return lastName;
  }

  @JsonProperty
  @Override
  public List<String> permissions() {
    return permissions;
  }

  @JsonProperty
  @Nullable
  @Override
  public String timezone() {
    return timezone;
  }

  @JsonProperty
  @Nullable
  @Override
  public Long sessionTimeoutMs() {
    return sessionTimeoutMs;
  }

  @JsonProperty
  @Nullable
  @Override
  public Startpage startpage() {
    return startpage;
  }

  @JsonProperty
  @Nullable
  @Override
  public List<String> roles() {
    return roles;
  }

  @JsonProperty
  @Override
  public boolean isServiceAccount() {
    return isServiceAccount;
  }

  @Override
  public String toString() {
    return "CreateUserRequest{"
        + "username=" + username + ", "
        + "password=" + password + ", "
        + "email=" + email + ", "
        + "firstName=" + firstName + ", "
        + "lastName=" + lastName + ", "
        + "permissions=" + permissions + ", "
        + "timezone=" + timezone + ", "
        + "sessionTimeoutMs=" + sessionTimeoutMs + ", "
        + "startpage=" + startpage + ", "
        + "roles=" + roles + ", "
        + "isServiceAccount=" + isServiceAccount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateUserRequest) {
      CreateUserRequest that = (CreateUserRequest) o;
      return this.username.equals(that.username())
          && this.password.equals(that.password())
          && this.email.equals(that.email())
          && this.firstName.equals(that.firstName())
          && this.lastName.equals(that.lastName())
          && this.permissions.equals(that.permissions())
          && (this.timezone == null ? that.timezone() == null : this.timezone.equals(that.timezone()))
          && (this.sessionTimeoutMs == null ? that.sessionTimeoutMs() == null : this.sessionTimeoutMs.equals(that.sessionTimeoutMs()))
          && (this.startpage == null ? that.startpage() == null : this.startpage.equals(that.startpage()))
          && (this.roles == null ? that.roles() == null : this.roles.equals(that.roles()))
          && this.isServiceAccount == that.isServiceAccount();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= username.hashCode();
    h$ *= 1000003;
    h$ ^= password.hashCode();
    h$ *= 1000003;
    h$ ^= email.hashCode();
    h$ *= 1000003;
    h$ ^= firstName.hashCode();
    h$ *= 1000003;
    h$ ^= lastName.hashCode();
    h$ *= 1000003;
    h$ ^= permissions.hashCode();
    h$ *= 1000003;
    h$ ^= (timezone == null) ? 0 : timezone.hashCode();
    h$ *= 1000003;
    h$ ^= (sessionTimeoutMs == null) ? 0 : sessionTimeoutMs.hashCode();
    h$ *= 1000003;
    h$ ^= (startpage == null) ? 0 : startpage.hashCode();
    h$ *= 1000003;
    h$ ^= (roles == null) ? 0 : roles.hashCode();
    h$ *= 1000003;
    h$ ^= isServiceAccount ? 1231 : 1237;
    return h$;
  }

}
