package org.graylog2.shared.system.stats.fs;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_FsStats_Filesystem extends FsStats.Filesystem {

  private final String path;

  private final String mount;

  private final String dev;

  private final String typeName;

  private final String sysTypeName;

  private final long total;

  private final long free;

  private final long available;

  private final long used;

  private final short usedPercent;

  private final long inodesTotal;

  private final long inodesFree;

  private final long inodesUsed;

  private final short inodesUsedPercent;

  private final long diskReads;

  private final long diskWrites;

  private final long diskReadBytes;

  private final long diskWriteBytes;

  private final double diskQueue;

  private final double diskServiceTime;

  $AutoValue_FsStats_Filesystem(
      String path,
      @Nullable String mount,
      @Nullable String dev,
      @Nullable String typeName,
      @Nullable String sysTypeName,
      long total,
      long free,
      long available,
      long used,
      short usedPercent,
      long inodesTotal,
      long inodesFree,
      long inodesUsed,
      short inodesUsedPercent,
      long diskReads,
      long diskWrites,
      long diskReadBytes,
      long diskWriteBytes,
      double diskQueue,
      double diskServiceTime) {
    if (path == null) {
      throw new NullPointerException("Null path");
    }
    this.path = path;
    this.mount = mount;
    this.dev = dev;
    this.typeName = typeName;
    this.sysTypeName = sysTypeName;
    this.total = total;
    this.free = free;
    this.available = available;
    this.used = used;
    this.usedPercent = usedPercent;
    this.inodesTotal = inodesTotal;
    this.inodesFree = inodesFree;
    this.inodesUsed = inodesUsed;
    this.inodesUsedPercent = inodesUsedPercent;
    this.diskReads = diskReads;
    this.diskWrites = diskWrites;
    this.diskReadBytes = diskReadBytes;
    this.diskWriteBytes = diskWriteBytes;
    this.diskQueue = diskQueue;
    this.diskServiceTime = diskServiceTime;
  }

  @JsonProperty
  @Override
  public String path() {
    return path;
  }

  @JsonProperty
  @Nullable
  @Override
  public String mount() {
    return mount;
  }

  @JsonProperty
  @Nullable
  @Override
  public String dev() {
    return dev;
  }

  @JsonProperty
  @Nullable
  @Override
  public String typeName() {
    return typeName;
  }

  @JsonProperty
  @Nullable
  @Override
  public String sysTypeName() {
    return sysTypeName;
  }

  @JsonProperty
  @Override
  public long total() {
    return total;
  }

  @JsonProperty
  @Override
  public long free() {
    return free;
  }

  @JsonProperty
  @Override
  public long available() {
    return available;
  }

  @JsonProperty
  @Override
  public long used() {
    return used;
  }

  @JsonProperty
  @Override
  public short usedPercent() {
    return usedPercent;
  }

  @JsonProperty
  @Override
  public long inodesTotal() {
    return inodesTotal;
  }

  @JsonProperty
  @Override
  public long inodesFree() {
    return inodesFree;
  }

  @JsonProperty
  @Override
  public long inodesUsed() {
    return inodesUsed;
  }

  @JsonProperty
  @Override
  public short inodesUsedPercent() {
    return inodesUsedPercent;
  }

  @JsonProperty
  @Override
  public long diskReads() {
    return diskReads;
  }

  @JsonProperty
  @Override
  public long diskWrites() {
    return diskWrites;
  }

  @JsonProperty
  @Override
  public long diskReadBytes() {
    return diskReadBytes;
  }

  @JsonProperty
  @Override
  public long diskWriteBytes() {
    return diskWriteBytes;
  }

  @JsonProperty
  @Override
  public double diskQueue() {
    return diskQueue;
  }

  @JsonProperty
  @Override
  public double diskServiceTime() {
    return diskServiceTime;
  }

  @Override
  public String toString() {
    return "Filesystem{"
        + "path=" + path + ", "
        + "mount=" + mount + ", "
        + "dev=" + dev + ", "
        + "typeName=" + typeName + ", "
        + "sysTypeName=" + sysTypeName + ", "
        + "total=" + total + ", "
        + "free=" + free + ", "
        + "available=" + available + ", "
        + "used=" + used + ", "
        + "usedPercent=" + usedPercent + ", "
        + "inodesTotal=" + inodesTotal + ", "
        + "inodesFree=" + inodesFree + ", "
        + "inodesUsed=" + inodesUsed + ", "
        + "inodesUsedPercent=" + inodesUsedPercent + ", "
        + "diskReads=" + diskReads + ", "
        + "diskWrites=" + diskWrites + ", "
        + "diskReadBytes=" + diskReadBytes + ", "
        + "diskWriteBytes=" + diskWriteBytes + ", "
        + "diskQueue=" + diskQueue + ", "
        + "diskServiceTime=" + diskServiceTime
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FsStats.Filesystem) {
      FsStats.Filesystem that = (FsStats.Filesystem) o;
      return this.path.equals(that.path())
          && (this.mount == null ? that.mount() == null : this.mount.equals(that.mount()))
          && (this.dev == null ? that.dev() == null : this.dev.equals(that.dev()))
          && (this.typeName == null ? that.typeName() == null : this.typeName.equals(that.typeName()))
          && (this.sysTypeName == null ? that.sysTypeName() == null : this.sysTypeName.equals(that.sysTypeName()))
          && this.total == that.total()
          && this.free == that.free()
          && this.available == that.available()
          && this.used == that.used()
          && this.usedPercent == that.usedPercent()
          && this.inodesTotal == that.inodesTotal()
          && this.inodesFree == that.inodesFree()
          && this.inodesUsed == that.inodesUsed()
          && this.inodesUsedPercent == that.inodesUsedPercent()
          && this.diskReads == that.diskReads()
          && this.diskWrites == that.diskWrites()
          && this.diskReadBytes == that.diskReadBytes()
          && this.diskWriteBytes == that.diskWriteBytes()
          && Double.doubleToLongBits(this.diskQueue) == Double.doubleToLongBits(that.diskQueue())
          && Double.doubleToLongBits(this.diskServiceTime) == Double.doubleToLongBits(that.diskServiceTime());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= path.hashCode();
    h$ *= 1000003;
    h$ ^= (mount == null) ? 0 : mount.hashCode();
    h$ *= 1000003;
    h$ ^= (dev == null) ? 0 : dev.hashCode();
    h$ *= 1000003;
    h$ ^= (typeName == null) ? 0 : typeName.hashCode();
    h$ *= 1000003;
    h$ ^= (sysTypeName == null) ? 0 : sysTypeName.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((total >>> 32) ^ total);
    h$ *= 1000003;
    h$ ^= (int) ((free >>> 32) ^ free);
    h$ *= 1000003;
    h$ ^= (int) ((available >>> 32) ^ available);
    h$ *= 1000003;
    h$ ^= (int) ((used >>> 32) ^ used);
    h$ *= 1000003;
    h$ ^= usedPercent;
    h$ *= 1000003;
    h$ ^= (int) ((inodesTotal >>> 32) ^ inodesTotal);
    h$ *= 1000003;
    h$ ^= (int) ((inodesFree >>> 32) ^ inodesFree);
    h$ *= 1000003;
    h$ ^= (int) ((inodesUsed >>> 32) ^ inodesUsed);
    h$ *= 1000003;
    h$ ^= inodesUsedPercent;
    h$ *= 1000003;
    h$ ^= (int) ((diskReads >>> 32) ^ diskReads);
    h$ *= 1000003;
    h$ ^= (int) ((diskWrites >>> 32) ^ diskWrites);
    h$ *= 1000003;
    h$ ^= (int) ((diskReadBytes >>> 32) ^ diskReadBytes);
    h$ *= 1000003;
    h$ ^= (int) ((diskWriteBytes >>> 32) ^ diskWriteBytes);
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(diskQueue) >>> 32) ^ Double.doubleToLongBits(diskQueue));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(diskServiceTime) >>> 32) ^ Double.doubleToLongBits(diskServiceTime));
    return h$;
  }

}
