package org.graylog2.system.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.mongo.MongoStats;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ClusterStats extends ClusterStats {

  private final ElasticsearchStats elasticsearchStats;

  private final MongoStats mongoStats;

  private final long streamCount;

  private final long streamRuleCount;

  private final Map<String, Long> streamRuleCountByStream;

  private final long userCount;

  private final long outputCount;

  private final Map<String, Long> outputCountByType;

  private final long dashboardCount;

  private final long inputCount;

  private final long globalInputCount;

  private final Map<String, Long> inputCountByType;

  private final long extractorCount;

  private final Map<Extractor.Type, Long> extractorCountByType;

  $AutoValue_ClusterStats(
      ElasticsearchStats elasticsearchStats,
      MongoStats mongoStats,
      long streamCount,
      long streamRuleCount,
      Map<String, Long> streamRuleCountByStream,
      long userCount,
      long outputCount,
      Map<String, Long> outputCountByType,
      long dashboardCount,
      long inputCount,
      long globalInputCount,
      Map<String, Long> inputCountByType,
      long extractorCount,
      Map<Extractor.Type, Long> extractorCountByType) {
    if (elasticsearchStats == null) {
      throw new NullPointerException("Null elasticsearchStats");
    }
    this.elasticsearchStats = elasticsearchStats;
    if (mongoStats == null) {
      throw new NullPointerException("Null mongoStats");
    }
    this.mongoStats = mongoStats;
    this.streamCount = streamCount;
    this.streamRuleCount = streamRuleCount;
    if (streamRuleCountByStream == null) {
      throw new NullPointerException("Null streamRuleCountByStream");
    }
    this.streamRuleCountByStream = streamRuleCountByStream;
    this.userCount = userCount;
    this.outputCount = outputCount;
    if (outputCountByType == null) {
      throw new NullPointerException("Null outputCountByType");
    }
    this.outputCountByType = outputCountByType;
    this.dashboardCount = dashboardCount;
    this.inputCount = inputCount;
    this.globalInputCount = globalInputCount;
    if (inputCountByType == null) {
      throw new NullPointerException("Null inputCountByType");
    }
    this.inputCountByType = inputCountByType;
    this.extractorCount = extractorCount;
    if (extractorCountByType == null) {
      throw new NullPointerException("Null extractorCountByType");
    }
    this.extractorCountByType = extractorCountByType;
  }

  @JsonProperty("elasticsearch")
  @Override
  public ElasticsearchStats elasticsearchStats() {
    return elasticsearchStats;
  }

  @JsonProperty("mongo")
  @Override
  public MongoStats mongoStats() {
    return mongoStats;
  }

  @JsonProperty
  @Override
  public long streamCount() {
    return streamCount;
  }

  @JsonProperty
  @Override
  public long streamRuleCount() {
    return streamRuleCount;
  }

  @JsonProperty
  @Override
  public Map<String, Long> streamRuleCountByStream() {
    return streamRuleCountByStream;
  }

  @JsonProperty
  @Override
  public long userCount() {
    return userCount;
  }

  @JsonProperty
  @Override
  public long outputCount() {
    return outputCount;
  }

  @JsonProperty
  @Override
  public Map<String, Long> outputCountByType() {
    return outputCountByType;
  }

  @JsonProperty
  @Override
  public long dashboardCount() {
    return dashboardCount;
  }

  @JsonProperty
  @Override
  public long inputCount() {
    return inputCount;
  }

  @JsonProperty
  @Override
  public long globalInputCount() {
    return globalInputCount;
  }

  @JsonProperty
  @Override
  public Map<String, Long> inputCountByType() {
    return inputCountByType;
  }

  @JsonProperty
  @Override
  public long extractorCount() {
    return extractorCount;
  }

  @JsonProperty
  @Override
  public Map<Extractor.Type, Long> extractorCountByType() {
    return extractorCountByType;
  }

  @Override
  public String toString() {
    return "ClusterStats{"
        + "elasticsearchStats=" + elasticsearchStats + ", "
        + "mongoStats=" + mongoStats + ", "
        + "streamCount=" + streamCount + ", "
        + "streamRuleCount=" + streamRuleCount + ", "
        + "streamRuleCountByStream=" + streamRuleCountByStream + ", "
        + "userCount=" + userCount + ", "
        + "outputCount=" + outputCount + ", "
        + "outputCountByType=" + outputCountByType + ", "
        + "dashboardCount=" + dashboardCount + ", "
        + "inputCount=" + inputCount + ", "
        + "globalInputCount=" + globalInputCount + ", "
        + "inputCountByType=" + inputCountByType + ", "
        + "extractorCount=" + extractorCount + ", "
        + "extractorCountByType=" + extractorCountByType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClusterStats) {
      ClusterStats that = (ClusterStats) o;
      return this.elasticsearchStats.equals(that.elasticsearchStats())
          && this.mongoStats.equals(that.mongoStats())
          && this.streamCount == that.streamCount()
          && this.streamRuleCount == that.streamRuleCount()
          && this.streamRuleCountByStream.equals(that.streamRuleCountByStream())
          && this.userCount == that.userCount()
          && this.outputCount == that.outputCount()
          && this.outputCountByType.equals(that.outputCountByType())
          && this.dashboardCount == that.dashboardCount()
          && this.inputCount == that.inputCount()
          && this.globalInputCount == that.globalInputCount()
          && this.inputCountByType.equals(that.inputCountByType())
          && this.extractorCount == that.extractorCount()
          && this.extractorCountByType.equals(that.extractorCountByType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= elasticsearchStats.hashCode();
    h$ *= 1000003;
    h$ ^= mongoStats.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((streamCount >>> 32) ^ streamCount);
    h$ *= 1000003;
    h$ ^= (int) ((streamRuleCount >>> 32) ^ streamRuleCount);
    h$ *= 1000003;
    h$ ^= streamRuleCountByStream.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((userCount >>> 32) ^ userCount);
    h$ *= 1000003;
    h$ ^= (int) ((outputCount >>> 32) ^ outputCount);
    h$ *= 1000003;
    h$ ^= outputCountByType.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((dashboardCount >>> 32) ^ dashboardCount);
    h$ *= 1000003;
    h$ ^= (int) ((inputCount >>> 32) ^ inputCount);
    h$ *= 1000003;
    h$ ^= (int) ((globalInputCount >>> 32) ^ globalInputCount);
    h$ *= 1000003;
    h$ ^= inputCountByType.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((extractorCount >>> 32) ^ extractorCount);
    h$ *= 1000003;
    h$ ^= extractorCountByType.hashCode();
    return h$;
  }

}
