package org.graylog2.system.stats.elasticsearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import org.graylog2.indexer.indices.HealthStatus;

final class AutoValue_ElasticsearchStats extends $AutoValue_ElasticsearchStats {
  AutoValue_ElasticsearchStats(String clusterName, String clusterVersion, HealthStatus status,
      ClusterHealth clusterHealth, NodesStats nodesStats, IndicesStats indicesStats) {
    super(clusterName, clusterVersion, status, clusterHealth, nodesStats, indicesStats);
  }

  @JsonIgnore
  public final String getClusterName() {
    return clusterName();
  }

  @JsonIgnore
  public final String getClusterVersion() {
    return clusterVersion();
  }

  @JsonIgnore
  public final HealthStatus getStatus() {
    return status();
  }

  @JsonIgnore
  public final ClusterHealth getClusterHealth() {
    return clusterHealth();
  }

  @JsonIgnore
  public final NodesStats getNodesStats() {
    return nodesStats();
  }

  @JsonIgnore
  public final IndicesStats getIndicesStats() {
    return indicesStats();
  }
}
