/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.errors.SearchTypeError;

public class ResultWindowLimitError
extends SearchTypeError {
    private final int resultWindowLimit;
    private static final String ERROR_DESCRIPTION = "Result window is too large, [from + size] must be less than or equal to: [%d]. This limit can be set by changing the [index.max_result_window] index level setting, but it is recommended to use more advanced methods in order to get distant chunks of results (i.e. scroll or search after)";

    ResultWindowLimitError(@Nonnull Query query, @Nonnull String searchTypeId, int resultWindowLimit) {
        super(query, searchTypeId, String.format(Locale.US, ERROR_DESCRIPTION, resultWindowLimit));
        this.resultWindowLimit = resultWindowLimit;
    }

    @JsonProperty(value="result_window_limit")
    public Integer getResultWindowLimit() {
        return this.resultWindowLimit;
    }
}

