/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.function.Consumer;
import javax.inject.Inject;
import org.graylog.plugins.views.search.export.ChunkDecorator;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesExporter;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;

public class DecoratingMessagesExporter
implements MessagesExporter {
    private final ExportBackend backend;
    private final ChunkDecorator chunkDecorator;

    @Inject
    public DecoratingMessagesExporter(ExportBackend backend, ChunkDecorator chunkDecorator) {
        this.backend = backend;
        this.chunkDecorator = chunkDecorator;
    }

    @Override
    public void export(ExportMessagesCommand command, Consumer<SimpleMessageChunk> chunkForwarder) {
        Consumer<SimpleMessageChunk> decoratedForwarder = chunk -> this.decorate(chunkForwarder, (SimpleMessageChunk)chunk, command);
        this.backend.run(command, decoratedForwarder);
    }

    private void decorate(Consumer<SimpleMessageChunk> chunkForwarder, SimpleMessageChunk chunk, ExportMessagesCommand command) {
        SimpleMessageChunk decoratedChunk = this.chunkDecorator.decorate(chunk, command);
        chunkForwarder.accept(decoratedChunk);
    }
}

