/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.github.rvesse.airline.annotations.restrictions.NotBlank;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MetricConfiguration;
import org.graylog.plugins.views.search.rest.scriptingapi.request.PercentileConfiguration;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Sortable;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;

public class Metric
implements Sortable {
    @JsonProperty(value="field")
    private String fieldName;
    @JsonProperty(value="function")
    @NotBlank
    @Valid
    private String functionName;
    @JsonProperty(value="sort")
    private SortSpec.Direction sort;
    @JsonProperty(value="configuration")
    @JsonTypeInfo(include=JsonTypeInfo.As.EXTERNAL_PROPERTY, use=JsonTypeInfo.Id.NAME, property="function")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="percentile", value=PercentileConfiguration.class)})
    private MetricConfiguration configuration;

    public Metric(@JsonProperty(value="function") String functionName, @JsonProperty(value="field") String fieldName, @JsonProperty(value="sort") SortSpec.Direction sort, @JsonProperty(value="configuration") MetricConfiguration configuration) {
        this.fieldName = fieldName;
        this.functionName = functionName;
        this.sort = sort;
        this.configuration = configuration;
    }

    public Metric(String functionName, String fieldName) {
        this(functionName, fieldName, null, null);
    }

    public static Optional<Metric> fromStringRepresentation(String metricString) {
        if (StringUtils.isBlank((String)metricString)) {
            return Optional.empty();
        }
        String[] split = metricString.split(":");
        String functionName = split[0];
        String fieldName = split.length > 1 ? split[1] : null;
        return Optional.of(new Metric(functionName, fieldName));
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String functionName() {
        return Optional.ofNullable(this.functionName).map(fn -> fn.toLowerCase(Locale.ROOT)).orElse(null);
    }

    @Override
    public SortSpec.Direction sort() {
        return this.sort;
    }

    public MetricConfiguration configuration() {
        return this.configuration;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Metric that = (Metric)obj;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.functionName, that.functionName) && Objects.equals((Object)this.sort, (Object)that.sort) && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.functionName, this.sort, this.configuration});
    }

    public String toString() {
        return "Metric[fieldName=" + this.fieldName + ", functionName=" + this.functionName + ", sort=" + this.sort + ", configuration=" + this.configuration + "]";
    }
}

