/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.commands.journal;

import com.google.inject.Module;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog2.Configuration;
import org.graylog2.audit.AuditBindings;
import org.graylog2.bindings.ConfigurationModule;
import org.graylog2.bootstrap.CmdLineTool;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.plugin.KafkaJournalConfiguration;
import org.graylog2.plugin.Plugin;
import org.graylog2.shared.bindings.SchedulerBindings;
import org.graylog2.shared.bindings.ServerStatusBindings;
import org.graylog2.shared.journal.LocalKafkaJournal;
import org.graylog2.shared.journal.LocalKafkaJournalModule;
import org.graylog2.shared.plugins.ChainingClassLoader;

public abstract class AbstractJournalCommand
extends CmdLineTool {
    protected static final Configuration configuration = new Configuration();
    protected final KafkaJournalConfiguration kafkaJournalConfiguration = new KafkaJournalConfiguration();
    protected LocalKafkaJournal journal;

    public AbstractJournalCommand() {
        this((String)null);
    }

    public AbstractJournalCommand(String commandName) {
        super(commandName, configuration);
    }

    @Override
    protected List<Module> getCommandBindings(FeatureFlags featureFlags) {
        return Arrays.asList(new Module[]{new ConfigurationModule(configuration), new ServerStatusBindings(this.capabilities()), new SchedulerBindings(), new LocalKafkaJournalModule(), new AuditBindings()});
    }

    @Override
    protected List<Object> getCommandConfigurationBeans() {
        return Arrays.asList(configuration, this.kafkaJournalConfiguration);
    }

    @Override
    protected boolean onlyLogErrors() {
        return true;
    }

    @Override
    protected Set<Plugin> loadPlugins(Path pluginPath, ChainingClassLoader chainingClassLoader) {
        return Collections.emptySet();
    }

    @Override
    protected void startCommand() {
        try {
            this.journal = (LocalKafkaJournal)this.injector.getInstance(LocalKafkaJournal.class);
            this.runCommand();
        }
        catch (Exception e) {
            System.err.println("Unable to read the message journal. Please make sure no other Graylog process is using the journal.");
        }
        finally {
            if (this.journal != null) {
                this.journal.stopAsync().awaitTerminated();
            }
        }
    }

    protected abstract void runCommand();
}

