/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRotationStrategy
implements RotationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRotationStrategy.class);
    private final AuditEventSender auditEventSender;
    private final NodeId nodeId;
    protected final ElasticsearchConfiguration elasticsearchConfiguration;
    protected final Indices indices;

    public AbstractRotationStrategy(AuditEventSender auditEventSender, NodeId nodeId, ElasticsearchConfiguration elasticsearchConfiguration, Indices indices) {
        this.auditEventSender = Objects.requireNonNull(auditEventSender);
        this.nodeId = nodeId;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.indices = indices;
    }

    @Nullable
    protected abstract Result shouldRotate(String var1, IndexSet var2);

    @Override
    public void rotate(IndexSet indexSet) {
        String indexName;
        Objects.requireNonNull(indexSet, "indexSet must not be null");
        String indexSetTitle = Objects.requireNonNull(indexSet.getConfig(), "Index set configuration must not be null").title();
        String strategyName = this.getClass().getCanonicalName();
        try {
            indexName = indexSet.getNewestIndex();
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not find current deflector target of index set <{}>. Aborting.", (Object)indexSetTitle, (Object)e);
            return;
        }
        this.indices.refresh(indexName);
        Result rotate = this.shouldRotate(indexName, indexSet);
        if (rotate == null) {
            LOG.error("Cannot perform rotation of index <{}> in index set <{}> with strategy <{}> at this moment", new Object[]{indexName, indexSetTitle, strategyName});
            return;
        }
        LOG.debug("Rotation strategy result: {}", (Object)rotate.getDescription());
        if (rotate.shouldRotate()) {
            LOG.info("Deflector index <{}> (index set <{}>) should be rotated ({}), Pointing deflector to new index now!", new Object[]{indexSetTitle, indexName, rotate.getDescription()});
            indexSet.cycle();
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_rotation:complete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"rotation_strategy", (Object)strategyName));
        } else {
            LOG.debug("Deflector index <{}> should not be rotated. Not doing anything.", (Object)indexName);
        }
    }

    public Result createResult(boolean shouldRotate, String message) {
        return new ResultImpl(shouldRotate, message);
    }

    public static interface Result {
        public String getDescription();

        public boolean shouldRotate();
    }

    static class ResultImpl
    implements Result {
        private final boolean shouldRotate;
        private final String message;

        private ResultImpl(boolean shouldRotate, String message) {
            this.shouldRotate = shouldRotate;
            this.message = message;
            LOG.debug("{} because of: {}", (Object)(shouldRotate ? "Rotating" : "Not rotating"), (Object)message);
        }

        @Override
        public String getDescription() {
            return this.message;
        }

        @Override
        public boolean shouldRotate() {
            return this.shouldRotate;
        }
    }
}

