/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.AutoValue_Migration_MigrationCompleted;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.MigrationDashboard;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.MigrationDashboardService;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.WidgetPosition;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
extends org.graylog2.migrations.Migration {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);
    private final MigrationDashboardService dashboardService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public Migration(MigrationDashboardService dashboardService, ClusterConfigService clusterConfigService) {
        this.dashboardService = dashboardService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-02-14T09:36:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        HashMap<String, String> dashboardIds = new HashMap<String, String>();
        for (MigrationDashboard dashboard : this.dashboardService.all()) {
            List<WidgetPosition> oldPositions = dashboard.getPositions();
            if (oldPositions.isEmpty()) {
                dashboardIds.put(dashboard.getId(), "skipped");
                continue;
            }
            ArrayList<WidgetPosition> widgetPositions = new ArrayList<WidgetPosition>(oldPositions.size());
            for (WidgetPosition position : oldPositions) {
                int newWidth = position.width() * 2;
                int newHeight = position.height() * 2;
                int newCol = this.adjustPosition(position.col());
                int newRow = this.adjustPosition(position.row());
                widgetPositions.add(WidgetPosition.builder().id(position.id()).width(newWidth).height(newHeight).col(newCol).row(newRow).build());
            }
            try {
                dashboard.setPositions(widgetPositions);
                this.dashboardService.save(dashboard);
                dashboardIds.put(dashboard.getId(), "updated");
            }
            catch (ValidationException e) {
                LOG.error("Could not update dashboard position: {}", (Throwable)e);
            }
        }
        this.clusterConfigService.write(MigrationCompleted.create(dashboardIds));
    }

    private int adjustPosition(int value) {
        return value * 2 - 1;
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="dashboard_ids")
        public abstract Map<String, String> dashboard_ids();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="dashboard_ids") Map<String, String> dashboardIds) {
            return new AutoValue_Migration_MigrationCompleted(dashboardIds);
        }
    }
}

