/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.messageprocessors.MessageFilterChainProcessor;
import org.graylog2.messageprocessors.MessageProcessorsConfig;
import org.graylog2.migrations.AutoValue_V20220719130704_ImprovedDefaultProcessingOrderMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220719130704_ImprovedDefaultProcessingOrderMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20220719130704_ImprovedDefaultProcessingOrderMigration.class);
    private final boolean isFreshInstallation;
    private final ClusterConfigService clusterConfigService;
    private final Set<String> processorClassNames;

    @Inject
    public V20220719130704_ImprovedDefaultProcessingOrderMigration(@Named(value="isFreshInstallation") boolean isFreshInstallation, ClusterConfigService clusterConfigService, Set<MessageProcessor.Descriptor> processorDescriptors) {
        this.isFreshInstallation = isFreshInstallation;
        this.clusterConfigService = clusterConfigService;
        this.processorClassNames = processorDescriptors.stream().map(MessageProcessor.Descriptor::className).collect(Collectors.toSet());
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-07-19T13:07:04Z");
    }

    @Override
    public void upgrade() {
        if (!this.isFreshInstallation) {
            return;
        }
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            return;
        }
        LOG.info("Fresh Graylog installation detected. Applying new default Message Processor order.");
        MessageProcessorsConfig config = this.clusterConfigService.getOrDefault(MessageProcessorsConfig.class, MessageProcessorsConfig.defaultConfig());
        List<String> order = config.withProcessors(this.processorClassNames).processorOrder();
        int filterChainIndex = order.indexOf(MessageFilterChainProcessor.class.getCanonicalName());
        int pipelineIndex = order.indexOf(PipelineInterpreter.class.getCanonicalName());
        Collections.swap(order, filterChainIndex, pipelineIndex);
        MessageProcessorsConfig newProcessorsConfig = MessageProcessorsConfig.defaultConfig().toBuilder().processorOrder(order).build().withProcessors(this.processorClassNames);
        this.clusterConfigService.write(newProcessorsConfig);
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V20220719130704_ImprovedDefaultProcessingOrderMigration_MigrationCompleted();
        }
    }
}

