/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.suggestions;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.database.suggestions.EntitySuggestionResponse;
import org.graylog2.database.suggestions.EntitySuggestionService;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="EntitySuggestions", tags={"cloud"})
@Path(value="/entity_suggestions")
@Produces(value={"application/json"})
public class EntitySuggestionResource
extends RestResource {
    private final EntitySuggestionService entitySuggestionService;

    @Inject
    public EntitySuggestionResource(EntitySuggestionService entitySuggestionService) {
        this.entitySuggestionService = entitySuggestionService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a paginated list of suggested entities")
    public EntitySuggestionResponse getPage(@ApiParam(name="collection") @QueryParam(value="collection") String collection, @ApiParam(name="column") @QueryParam(value="column") @DefaultValue(value="title") String column, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="10") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query) {
        return this.entitySuggestionService.suggest(collection, column, query, page, perPage, this.getSubject());
    }
}

