/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import javax.inject.Inject;
import org.graylog2.security.SafeClasses;
import org.graylog2.security.UnsafeClassLoadingAttemptException;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.utilities.StringUtils;

public class RestrictedChainingClassLoader {
    private final ChainingClassLoader delegate;
    private final SafeClasses safeClasses;

    @Inject
    public RestrictedChainingClassLoader(ChainingClassLoader delegate, SafeClasses safeClasses) {
        this.delegate = delegate;
        this.safeClasses = safeClasses;
    }

    public Class<?> loadClassSafely(String name) throws ClassNotFoundException, UnsafeClassLoadingAttemptException {
        if (this.safeClasses.isSafeToLoad(name)) {
            return this.delegate.loadClass(name);
        }
        throw new UnsafeClassLoadingAttemptException(StringUtils.f("Prevented loading of unsafe class \"%s\". Consider adjusting the configuration setting \"%s\", if you think that this is a mistake.", name, "safe_classes"));
    }
}

