package org.graylog.events.fields;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FieldValue extends FieldValue {

  private final FieldValueType dataType;

  private final String value;

  private AutoValue_FieldValue(
      FieldValueType dataType,
      String value) {
    this.dataType = dataType;
    this.value = value;
  }

  @Override
  public FieldValueType dataType() {
    return dataType;
  }

  @Override
  public String value() {
    return value;
  }

  @Override
  public String toString() {
    return "FieldValue{"
        + "dataType=" + dataType + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FieldValue) {
      FieldValue that = (FieldValue) o;
      return this.dataType.equals(that.dataType())
          && this.value.equals(that.value());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= dataType.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  @Override
  public FieldValue.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FieldValue.Builder {
    private FieldValueType dataType;
    private String value;
    Builder() {
    }
    private Builder(FieldValue source) {
      this.dataType = source.dataType();
      this.value = source.value();
    }
    @Override
    public FieldValue.Builder dataType(FieldValueType dataType) {
      if (dataType == null) {
        throw new NullPointerException("Null dataType");
      }
      this.dataType = dataType;
      return this;
    }
    @Override
    public FieldValue.Builder value(String value) {
      if (value == null) {
        throw new NullPointerException("Null value");
      }
      this.value = value;
      return this;
    }
    @Override
    public FieldValue build() {
      String missing = "";
      if (this.dataType == null) {
        missing += " dataType";
      }
      if (this.value == null) {
        missing += " value";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FieldValue(
          this.dataType,
          this.value);
    }
  }

}
