package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.graylog.events.event.EventDto;
import org.graylog2.plugin.MessageSummary;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventNotificationModelData extends EventNotificationModelData {

  private final String eventDefinitionId;

  private final String eventDefinitionType;

  private final String eventDefinitionTitle;

  private final String eventDefinitionDescription;

  private final String jobDefinitionId;

  private final String jobTriggerId;

  private final EventDto event;

  private final ImmutableList<MessageSummary> backlog;

  private AutoValue_EventNotificationModelData(
      String eventDefinitionId,
      String eventDefinitionType,
      String eventDefinitionTitle,
      String eventDefinitionDescription,
      String jobDefinitionId,
      String jobTriggerId,
      EventDto event,
      ImmutableList<MessageSummary> backlog) {
    this.eventDefinitionId = eventDefinitionId;
    this.eventDefinitionType = eventDefinitionType;
    this.eventDefinitionTitle = eventDefinitionTitle;
    this.eventDefinitionDescription = eventDefinitionDescription;
    this.jobDefinitionId = jobDefinitionId;
    this.jobTriggerId = jobTriggerId;
    this.event = event;
    this.backlog = backlog;
  }

  @JsonProperty("event_definition_id")
  @Override
  public String eventDefinitionId() {
    return eventDefinitionId;
  }

  @JsonProperty("event_definition_type")
  @Override
  public String eventDefinitionType() {
    return eventDefinitionType;
  }

  @JsonProperty("event_definition_title")
  @Override
  public String eventDefinitionTitle() {
    return eventDefinitionTitle;
  }

  @JsonProperty("event_definition_description")
  @Override
  public String eventDefinitionDescription() {
    return eventDefinitionDescription;
  }

  @JsonProperty("job_definition_id")
  @Override
  public String jobDefinitionId() {
    return jobDefinitionId;
  }

  @JsonProperty("job_trigger_id")
  @Override
  public String jobTriggerId() {
    return jobTriggerId;
  }

  @JsonProperty("event")
  @Override
  public EventDto event() {
    return event;
  }

  @JsonProperty("backlog")
  @Override
  public ImmutableList<MessageSummary> backlog() {
    return backlog;
  }

  @Override
  public String toString() {
    return "EventNotificationModelData{"
        + "eventDefinitionId=" + eventDefinitionId + ", "
        + "eventDefinitionType=" + eventDefinitionType + ", "
        + "eventDefinitionTitle=" + eventDefinitionTitle + ", "
        + "eventDefinitionDescription=" + eventDefinitionDescription + ", "
        + "jobDefinitionId=" + jobDefinitionId + ", "
        + "jobTriggerId=" + jobTriggerId + ", "
        + "event=" + event + ", "
        + "backlog=" + backlog
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventNotificationModelData) {
      EventNotificationModelData that = (EventNotificationModelData) o;
      return this.eventDefinitionId.equals(that.eventDefinitionId())
          && this.eventDefinitionType.equals(that.eventDefinitionType())
          && this.eventDefinitionTitle.equals(that.eventDefinitionTitle())
          && this.eventDefinitionDescription.equals(that.eventDefinitionDescription())
          && this.jobDefinitionId.equals(that.jobDefinitionId())
          && this.jobTriggerId.equals(that.jobTriggerId())
          && this.event.equals(that.event())
          && this.backlog.equals(that.backlog());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= eventDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionType.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionTitle.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionDescription.hashCode();
    h$ *= 1000003;
    h$ ^= jobDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= jobTriggerId.hashCode();
    h$ *= 1000003;
    h$ ^= event.hashCode();
    h$ *= 1000003;
    h$ ^= backlog.hashCode();
    return h$;
  }

  @Override
  public EventNotificationModelData.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventNotificationModelData.Builder {
    private String eventDefinitionId;
    private String eventDefinitionType;
    private String eventDefinitionTitle;
    private String eventDefinitionDescription;
    private String jobDefinitionId;
    private String jobTriggerId;
    private EventDto event;
    private ImmutableList<MessageSummary> backlog;
    Builder() {
    }
    private Builder(EventNotificationModelData source) {
      this.eventDefinitionId = source.eventDefinitionId();
      this.eventDefinitionType = source.eventDefinitionType();
      this.eventDefinitionTitle = source.eventDefinitionTitle();
      this.eventDefinitionDescription = source.eventDefinitionDescription();
      this.jobDefinitionId = source.jobDefinitionId();
      this.jobTriggerId = source.jobTriggerId();
      this.event = source.event();
      this.backlog = source.backlog();
    }
    @Override
    public EventNotificationModelData.Builder eventDefinitionId(String eventDefinitionId) {
      if (eventDefinitionId == null) {
        throw new NullPointerException("Null eventDefinitionId");
      }
      this.eventDefinitionId = eventDefinitionId;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder eventDefinitionType(String eventDefinitionType) {
      if (eventDefinitionType == null) {
        throw new NullPointerException("Null eventDefinitionType");
      }
      this.eventDefinitionType = eventDefinitionType;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder eventDefinitionTitle(String eventDefinitionTitle) {
      if (eventDefinitionTitle == null) {
        throw new NullPointerException("Null eventDefinitionTitle");
      }
      this.eventDefinitionTitle = eventDefinitionTitle;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder eventDefinitionDescription(String eventDefinitionDescription) {
      if (eventDefinitionDescription == null) {
        throw new NullPointerException("Null eventDefinitionDescription");
      }
      this.eventDefinitionDescription = eventDefinitionDescription;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder jobDefinitionId(String jobDefinitionId) {
      if (jobDefinitionId == null) {
        throw new NullPointerException("Null jobDefinitionId");
      }
      this.jobDefinitionId = jobDefinitionId;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder jobTriggerId(String jobTriggerId) {
      if (jobTriggerId == null) {
        throw new NullPointerException("Null jobTriggerId");
      }
      this.jobTriggerId = jobTriggerId;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder event(EventDto event) {
      if (event == null) {
        throw new NullPointerException("Null event");
      }
      this.event = event;
      return this;
    }
    @Override
    public EventNotificationModelData.Builder backlog(List<MessageSummary> backlog) {
      this.backlog = ImmutableList.copyOf(backlog);
      return this;
    }
    @Override
    public EventNotificationModelData build() {
      String missing = "";
      if (this.eventDefinitionId == null) {
        missing += " eventDefinitionId";
      }
      if (this.eventDefinitionType == null) {
        missing += " eventDefinitionType";
      }
      if (this.eventDefinitionTitle == null) {
        missing += " eventDefinitionTitle";
      }
      if (this.eventDefinitionDescription == null) {
        missing += " eventDefinitionDescription";
      }
      if (this.jobDefinitionId == null) {
        missing += " jobDefinitionId";
      }
      if (this.jobTriggerId == null) {
        missing += " jobTriggerId";
      }
      if (this.event == null) {
        missing += " event";
      }
      if (this.backlog == null) {
        missing += " backlog";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventNotificationModelData(
          this.eventDefinitionId,
          this.eventDefinitionType,
          this.eventDefinitionTitle,
          this.eventDefinitionDescription,
          this.jobDefinitionId,
          this.jobTriggerId,
          this.event,
          this.backlog);
    }
  }

}
