package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NotificationDto extends NotificationDto {

  private final String id;

  private final String title;

  private final String description;

  private final EventNotificationConfig config;

  private AutoValue_NotificationDto(
      @Nullable String id,
      String title,
      String description,
      EventNotificationConfig config) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.config = config;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("config")
  @Override
  public EventNotificationConfig config() {
    return config;
  }

  @Override
  public String toString() {
    return "NotificationDto{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NotificationDto) {
      NotificationDto that = (NotificationDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  @Override
  public NotificationDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends NotificationDto.Builder {
    private String id;
    private String title;
    private String description;
    private EventNotificationConfig config;
    Builder() {
    }
    private Builder(NotificationDto source) {
      this.id = source.id();
      this.title = source.title();
      this.description = source.description();
      this.config = source.config();
    }
    @Override
    public NotificationDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public NotificationDto.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public NotificationDto.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public NotificationDto.Builder config(EventNotificationConfig config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public NotificationDto build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_NotificationDto(
          this.id,
          this.title,
          this.description,
          this.config);
    }
  }

}
