package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotBlank;
import org.joda.time.DateTimeZone;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EmailEventNotificationConfig extends EmailEventNotificationConfig {

  private final String type;

  private final String sender;

  private final String replyTo;

  private final @NotBlank String subject;

  private final String bodyTemplate;

  private final String htmlBodyTemplate;

  private final Set<String> emailRecipients;

  private final Set<String> userRecipients;

  private final DateTimeZone timeZone;

  private AutoValue_EmailEventNotificationConfig(
      String type,
      String sender,
      String replyTo,
      @NotBlank String subject,
      String bodyTemplate,
      String htmlBodyTemplate,
      Set<String> emailRecipients,
      Set<String> userRecipients,
      DateTimeZone timeZone) {
    this.type = type;
    this.sender = sender;
    this.replyTo = replyTo;
    this.subject = subject;
    this.bodyTemplate = bodyTemplate;
    this.htmlBodyTemplate = htmlBodyTemplate;
    this.emailRecipients = emailRecipients;
    this.userRecipients = userRecipients;
    this.timeZone = timeZone;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("sender")
  @Override
  public String sender() {
    return sender;
  }

  @JsonProperty("reply_to")
  @Override
  public String replyTo() {
    return replyTo;
  }

  @JsonProperty("subject")
  @Override
  public @NotBlank String subject() {
    return subject;
  }

  @JsonProperty("body_template")
  @Override
  public String bodyTemplate() {
    return bodyTemplate;
  }

  @JsonProperty("html_body_template")
  @Override
  public String htmlBodyTemplate() {
    return htmlBodyTemplate;
  }

  @JsonProperty("email_recipients")
  @Override
  public Set<String> emailRecipients() {
    return emailRecipients;
  }

  @JsonProperty("user_recipients")
  @Override
  public Set<String> userRecipients() {
    return userRecipients;
  }

  @JsonProperty("time_zone")
  @Override
  public DateTimeZone timeZone() {
    return timeZone;
  }

  @Override
  public String toString() {
    return "EmailEventNotificationConfig{"
        + "type=" + type + ", "
        + "sender=" + sender + ", "
        + "replyTo=" + replyTo + ", "
        + "subject=" + subject + ", "
        + "bodyTemplate=" + bodyTemplate + ", "
        + "htmlBodyTemplate=" + htmlBodyTemplate + ", "
        + "emailRecipients=" + emailRecipients + ", "
        + "userRecipients=" + userRecipients + ", "
        + "timeZone=" + timeZone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EmailEventNotificationConfig) {
      EmailEventNotificationConfig that = (EmailEventNotificationConfig) o;
      return this.type.equals(that.type())
          && this.sender.equals(that.sender())
          && this.replyTo.equals(that.replyTo())
          && this.subject.equals(that.subject())
          && this.bodyTemplate.equals(that.bodyTemplate())
          && this.htmlBodyTemplate.equals(that.htmlBodyTemplate())
          && this.emailRecipients.equals(that.emailRecipients())
          && this.userRecipients.equals(that.userRecipients())
          && this.timeZone.equals(that.timeZone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= sender.hashCode();
    h$ *= 1000003;
    h$ ^= replyTo.hashCode();
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= bodyTemplate.hashCode();
    h$ *= 1000003;
    h$ ^= htmlBodyTemplate.hashCode();
    h$ *= 1000003;
    h$ ^= emailRecipients.hashCode();
    h$ *= 1000003;
    h$ ^= userRecipients.hashCode();
    h$ *= 1000003;
    h$ ^= timeZone.hashCode();
    return h$;
  }

  static final class Builder extends EmailEventNotificationConfig.Builder {
    private String type;
    private String sender;
    private String replyTo;
    private @NotBlank String subject;
    private String bodyTemplate;
    private String htmlBodyTemplate;
    private Set<String> emailRecipients;
    private Set<String> userRecipients;
    private DateTimeZone timeZone;
    Builder() {
    }
    @Override
    public EmailEventNotificationConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder sender(String sender) {
      if (sender == null) {
        throw new NullPointerException("Null sender");
      }
      this.sender = sender;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder replyTo(String replyTo) {
      if (replyTo == null) {
        throw new NullPointerException("Null replyTo");
      }
      this.replyTo = replyTo;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder subject(String subject) {
      if (subject == null) {
        throw new NullPointerException("Null subject");
      }
      this.subject = subject;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder bodyTemplate(String bodyTemplate) {
      if (bodyTemplate == null) {
        throw new NullPointerException("Null bodyTemplate");
      }
      this.bodyTemplate = bodyTemplate;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder htmlBodyTemplate(String htmlBodyTemplate) {
      if (htmlBodyTemplate == null) {
        throw new NullPointerException("Null htmlBodyTemplate");
      }
      this.htmlBodyTemplate = htmlBodyTemplate;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder emailRecipients(Set<String> emailRecipients) {
      if (emailRecipients == null) {
        throw new NullPointerException("Null emailRecipients");
      }
      this.emailRecipients = emailRecipients;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder userRecipients(Set<String> userRecipients) {
      if (userRecipients == null) {
        throw new NullPointerException("Null userRecipients");
      }
      this.userRecipients = userRecipients;
      return this;
    }
    @Override
    public EmailEventNotificationConfig.Builder timeZone(DateTimeZone timeZone) {
      if (timeZone == null) {
        throw new NullPointerException("Null timeZone");
      }
      this.timeZone = timeZone;
      return this;
    }
    @Override
    public EmailEventNotificationConfig build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.sender == null) {
        missing += " sender";
      }
      if (this.replyTo == null) {
        missing += " replyTo";
      }
      if (this.subject == null) {
        missing += " subject";
      }
      if (this.bodyTemplate == null) {
        missing += " bodyTemplate";
      }
      if (this.htmlBodyTemplate == null) {
        missing += " htmlBodyTemplate";
      }
      if (this.emailRecipients == null) {
        missing += " emailRecipients";
      }
      if (this.userRecipients == null) {
        missing += " userRecipients";
      }
      if (this.timeZone == null) {
        missing += " timeZone";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EmailEventNotificationConfig(
          this.type,
          this.sender,
          this.replyTo,
          this.subject,
          this.bodyTemplate,
          this.htmlBodyTemplate,
          this.emailRecipients,
          this.userRecipients,
          this.timeZone);
    }
  }

}
