package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationEventProcessorParameters extends AggregationEventProcessorParameters {

  private final String type;

  private final TimeRange timerange;

  private final ImmutableSet<String> streams;

  private final int batchSize;

  private AutoValue_AggregationEventProcessorParameters(
      String type,
      TimeRange timerange,
      ImmutableSet<String> streams,
      int batchSize) {
    this.type = type;
    this.timerange = timerange;
    this.streams = streams;
    this.batchSize = batchSize;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("timerange")
  @Override
  public TimeRange timerange() {
    return timerange;
  }

  @JsonProperty("streams")
  @Override
  public ImmutableSet<String> streams() {
    return streams;
  }

  @JsonProperty("batch_size")
  @Override
  public int batchSize() {
    return batchSize;
  }

  @Override
  public String toString() {
    return "AggregationEventProcessorParameters{"
        + "type=" + type + ", "
        + "timerange=" + timerange + ", "
        + "streams=" + streams + ", "
        + "batchSize=" + batchSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationEventProcessorParameters) {
      AggregationEventProcessorParameters that = (AggregationEventProcessorParameters) o;
      return this.type.equals(that.type())
          && this.timerange.equals(that.timerange())
          && this.streams.equals(that.streams())
          && this.batchSize == that.batchSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= batchSize;
    return h$;
  }

  @Override
  public AggregationEventProcessorParameters.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationEventProcessorParameters.Builder {
    private String type;
    private TimeRange timerange;
    private ImmutableSet<String> streams;
    private Integer batchSize;
    Builder() {
    }
    private Builder(AggregationEventProcessorParameters source) {
      this.type = source.type();
      this.timerange = source.timerange();
      this.streams = source.streams();
      this.batchSize = source.batchSize();
    }
    @Override
    public AggregationEventProcessorParameters.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public AggregationEventProcessorParameters.Builder timerange(TimeRange timerange) {
      if (timerange == null) {
        throw new NullPointerException("Null timerange");
      }
      this.timerange = timerange;
      return this;
    }
    @Override
    public AggregationEventProcessorParameters.Builder streams(Set<String> streams) {
      this.streams = ImmutableSet.copyOf(streams);
      return this;
    }
    @Override
    public AggregationEventProcessorParameters.Builder batchSize(int batchSize) {
      this.batchSize = batchSize;
      return this;
    }
    @Override
    public AggregationEventProcessorParameters build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.timerange == null) {
        missing += " timerange";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.batchSize == null) {
        missing += " batchSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationEventProcessorParameters(
          this.type,
          this.timerange,
          this.streams,
          this.batchSize);
    }
  }

}
