package org.graylog.plugins.netflow.v5;

import java.net.InetAddress;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NetFlowV5Record extends NetFlowV5Record {

  private final InetAddress srcAddr;

  private final InetAddress dstAddr;

  private final InetAddress nextHop;

  private final int inputIface;

  private final int outputIface;

  private final long packetCount;

  private final long octetCount;

  private final long first;

  private final long last;

  private final int srcPort;

  private final int dstPort;

  private final short tcpFlags;

  private final short protocol;

  private final short tos;

  private final int srcAs;

  private final int dstAs;

  private final short srcMask;

  private final short dstMask;

  AutoValue_NetFlowV5Record(
      InetAddress srcAddr,
      InetAddress dstAddr,
      InetAddress nextHop,
      int inputIface,
      int outputIface,
      long packetCount,
      long octetCount,
      long first,
      long last,
      int srcPort,
      int dstPort,
      short tcpFlags,
      short protocol,
      short tos,
      int srcAs,
      int dstAs,
      short srcMask,
      short dstMask) {
    if (srcAddr == null) {
      throw new NullPointerException("Null srcAddr");
    }
    this.srcAddr = srcAddr;
    if (dstAddr == null) {
      throw new NullPointerException("Null dstAddr");
    }
    this.dstAddr = dstAddr;
    if (nextHop == null) {
      throw new NullPointerException("Null nextHop");
    }
    this.nextHop = nextHop;
    this.inputIface = inputIface;
    this.outputIface = outputIface;
    this.packetCount = packetCount;
    this.octetCount = octetCount;
    this.first = first;
    this.last = last;
    this.srcPort = srcPort;
    this.dstPort = dstPort;
    this.tcpFlags = tcpFlags;
    this.protocol = protocol;
    this.tos = tos;
    this.srcAs = srcAs;
    this.dstAs = dstAs;
    this.srcMask = srcMask;
    this.dstMask = dstMask;
  }

  @Override
  public InetAddress srcAddr() {
    return srcAddr;
  }

  @Override
  public InetAddress dstAddr() {
    return dstAddr;
  }

  @Override
  public InetAddress nextHop() {
    return nextHop;
  }

  @Override
  public int inputIface() {
    return inputIface;
  }

  @Override
  public int outputIface() {
    return outputIface;
  }

  @Override
  public long packetCount() {
    return packetCount;
  }

  @Override
  public long octetCount() {
    return octetCount;
  }

  @Override
  public long first() {
    return first;
  }

  @Override
  public long last() {
    return last;
  }

  @Override
  public int srcPort() {
    return srcPort;
  }

  @Override
  public int dstPort() {
    return dstPort;
  }

  @Override
  public short tcpFlags() {
    return tcpFlags;
  }

  @Override
  public short protocol() {
    return protocol;
  }

  @Override
  public short tos() {
    return tos;
  }

  @Override
  public int srcAs() {
    return srcAs;
  }

  @Override
  public int dstAs() {
    return dstAs;
  }

  @Override
  public short srcMask() {
    return srcMask;
  }

  @Override
  public short dstMask() {
    return dstMask;
  }

  @Override
  public String toString() {
    return "NetFlowV5Record{"
        + "srcAddr=" + srcAddr + ", "
        + "dstAddr=" + dstAddr + ", "
        + "nextHop=" + nextHop + ", "
        + "inputIface=" + inputIface + ", "
        + "outputIface=" + outputIface + ", "
        + "packetCount=" + packetCount + ", "
        + "octetCount=" + octetCount + ", "
        + "first=" + first + ", "
        + "last=" + last + ", "
        + "srcPort=" + srcPort + ", "
        + "dstPort=" + dstPort + ", "
        + "tcpFlags=" + tcpFlags + ", "
        + "protocol=" + protocol + ", "
        + "tos=" + tos + ", "
        + "srcAs=" + srcAs + ", "
        + "dstAs=" + dstAs + ", "
        + "srcMask=" + srcMask + ", "
        + "dstMask=" + dstMask
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NetFlowV5Record) {
      NetFlowV5Record that = (NetFlowV5Record) o;
      return this.srcAddr.equals(that.srcAddr())
          && this.dstAddr.equals(that.dstAddr())
          && this.nextHop.equals(that.nextHop())
          && this.inputIface == that.inputIface()
          && this.outputIface == that.outputIface()
          && this.packetCount == that.packetCount()
          && this.octetCount == that.octetCount()
          && this.first == that.first()
          && this.last == that.last()
          && this.srcPort == that.srcPort()
          && this.dstPort == that.dstPort()
          && this.tcpFlags == that.tcpFlags()
          && this.protocol == that.protocol()
          && this.tos == that.tos()
          && this.srcAs == that.srcAs()
          && this.dstAs == that.dstAs()
          && this.srcMask == that.srcMask()
          && this.dstMask == that.dstMask();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= srcAddr.hashCode();
    h$ *= 1000003;
    h$ ^= dstAddr.hashCode();
    h$ *= 1000003;
    h$ ^= nextHop.hashCode();
    h$ *= 1000003;
    h$ ^= inputIface;
    h$ *= 1000003;
    h$ ^= outputIface;
    h$ *= 1000003;
    h$ ^= (int) ((packetCount >>> 32) ^ packetCount);
    h$ *= 1000003;
    h$ ^= (int) ((octetCount >>> 32) ^ octetCount);
    h$ *= 1000003;
    h$ ^= (int) ((first >>> 32) ^ first);
    h$ *= 1000003;
    h$ ^= (int) ((last >>> 32) ^ last);
    h$ *= 1000003;
    h$ ^= srcPort;
    h$ *= 1000003;
    h$ ^= dstPort;
    h$ *= 1000003;
    h$ ^= tcpFlags;
    h$ *= 1000003;
    h$ ^= protocol;
    h$ *= 1000003;
    h$ ^= tos;
    h$ *= 1000003;
    h$ ^= srcAs;
    h$ *= 1000003;
    h$ ^= dstAs;
    h$ *= 1000003;
    h$ ^= srcMask;
    h$ *= 1000003;
    h$ ^= dstMask;
    return h$;
  }

}
